/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.FileSystemProvisioner;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractModelObject;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.LabelFinder;
import hudson.model.Messages;
import hudson.model.Queue;
import hudson.model.ReconfigurableDescribable;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.labels.LabelAtom;
import hudson.model.queue.CauseOfBlockage;
import hudson.remoting.Callable;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerListener;
import hudson.slaves.NodeDescriptor;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.OfflineCause;
import hudson.util.ClockDifference;
import hudson.util.DescribableList;
import hudson.util.EnumConverter;
import hudson.util.TagCloud;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import jenkins.util.io.OnMaster;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.Converter;
import org.jvnet.localizer.Localizable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.ProtectedExternally;
import org.kohsuke.stapler.BindInterceptor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.springframework.security.core.Authentication;

@ExportedBean
@BridgeMethodsAdded
public abstract class Node
extends AbstractModelObject
implements ReconfigurableDescribable<Node>,
ExtensionPoint,
AccessControlled,
OnMaster,
Saveable {
    private static final Logger LOGGER = Logger.getLogger(Node.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean SKIP_BUILD_CHECK_ON_FLYWEIGHTS = SystemProperties.getBoolean(Node.class.getName() + ".SKIP_BUILD_CHECK_ON_FLYWEIGHTS", true);
    protected volatile transient boolean holdOffLaunchUntilSave;
    private OfflineCause temporaryOfflineCause;

    @Override
    public String getDisplayName() {
        return this.getNodeName();
    }

    @Override
    public String getSearchUrl() {
        Computer c = this.toComputer();
        if (c != null) {
            return c.getUrl();
        }
        return "computer/" + Util.rawEncode(this.getNodeName());
    }

    public boolean isHoldOffLaunchUntilSave() {
        return this.holdOffLaunchUntilSave;
    }

    @Override
    public void save() throws IOException {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            jenkins.updateNode(this);
        }
    }

    @Exported(visibility=999)
    @NonNull
    public abstract String getNodeName();

    @Deprecated
    public abstract void setNodeName(String var1);

    @Exported
    public abstract String getNodeDescription();

    public abstract Launcher createLauncher(TaskListener var1);

    @Exported
    public abstract int getNumExecutors();

    @Exported
    public abstract Mode getMode();

    @CheckForNull
    public final Computer toComputer() {
        Jenkins ciBase = Jenkins.get();
        return ciBase.getComputer(this);
    }

    @CheckForNull
    public final VirtualChannel getChannel() {
        Computer c = this.toComputer();
        return c == null ? null : c.getChannel();
    }

    @Restricted(value={ProtectedExternally.class})
    @CheckForNull
    protected abstract Computer createComputer();

    public boolean isAcceptingTasks() {
        return true;
    }

    void setTemporaryOfflineCause(OfflineCause cause) {
        try {
            if (this.temporaryOfflineCause != cause) {
                this.temporaryOfflineCause = cause;
                this.save();
            }
        }
        catch (IOException e) {
            LOGGER.warning("Unable to complete save, temporary offline status will not be persisted: " + e.getMessage());
        }
    }

    public TagCloud<LabelAtom> getLabelCloud() {
        return new TagCloud<LabelAtom>(this.getAssignedLabels(), Label::getTiedJobCount);
    }

    @Exported
    public Set<LabelAtom> getAssignedLabels() {
        Set<LabelAtom> r = Label.parse(this.getLabelString());
        r.add(this.getSelfLabel());
        r.addAll(this.getDynamicLabels());
        return Collections.unmodifiableSet(r);
    }

    private HashSet<LabelAtom> getDynamicLabels() {
        HashSet<LabelAtom> result = new HashSet<LabelAtom>();
        for (LabelFinder labeler : LabelFinder.all()) {
            for (Label label : labeler.findLabels(this)) {
                if (!(label instanceof LabelAtom)) continue;
                result.add((LabelAtom)label);
            }
        }
        return result;
    }

    public abstract String getLabelString();

    public void setLabelString(String labelString) throws IOException {
        throw new UnsupportedOperationException();
    }

    @NonNull
    @WithBridgeMethods(value={Label.class})
    public LabelAtom getSelfLabel() {
        return LabelAtom.get(this.getNodeName());
    }

    @Deprecated
    public CauseOfBlockage canTake(Queue.Task task) {
        return null;
    }

    public CauseOfBlockage canTake(Queue.BuildableItem item) {
        Label l = item.getAssignedLabel();
        if (l != null && !l.contains(this)) {
            return CauseOfBlockage.fromMessage(Messages._Node_LabelMissing(this.getDisplayName(), l));
        }
        if (l == null && this.getMode() == Mode.EXCLUSIVE && (!(item.task instanceof Queue.FlyweightTask) || !(this instanceof Jenkins) && Jenkins.get().getNumExecutors() >= 1 && Jenkins.get().getMode() != Mode.EXCLUSIVE)) {
            return CauseOfBlockage.fromMessage(Messages._Node_BecauseNodeIsReserved(this.getDisplayName()));
        }
        Authentication identity = item.authenticate2();
        if (!(SKIP_BUILD_CHECK_ON_FLYWEIGHTS && item.task instanceof Queue.FlyweightTask || this.hasPermission2(identity, Computer.BUILD))) {
            return CauseOfBlockage.fromMessage(Messages._Node_LackingBuildPermission(identity.getName(), this.getDisplayName()));
        }
        for (NodeProperty prop : this.getNodeProperties()) {
            CauseOfBlockage c;
            try {
                c = prop.canTake(item);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, t, () -> String.format("Exception evaluating if the node '%s' can take the task '%s'", this.getNodeName(), item.task.getName()));
                c = CauseOfBlockage.fromMessage(Messages._Queue_ExceptionCanTake());
            }
            if (c == null) continue;
            return c;
        }
        if (!this.isAcceptingTasks()) {
            return new CauseOfBlockage.BecauseNodeIsNotAcceptingTasks(this);
        }
        return null;
    }

    @CheckForNull
    public abstract FilePath getWorkspaceFor(TopLevelItem var1);

    @CheckForNull
    public abstract FilePath getRootPath();

    @CheckForNull
    public FilePath createPath(String absolutePath) {
        VirtualChannel ch = this.getChannel();
        if (ch == null) {
            return null;
        }
        return new FilePath(ch, absolutePath);
    }

    @Deprecated
    public FileSystemProvisioner getFileSystemProvisioner() {
        return FileSystemProvisioner.DEFAULT;
    }

    @NonNull
    public abstract DescribableList<NodeProperty<?>, NodePropertyDescriptor> getNodeProperties();

    @CheckForNull
    public <T extends NodeProperty> T getNodeProperty(Class<T> clazz) {
        for (NodeProperty p : this.getNodeProperties()) {
            if (!clazz.isInstance(p)) continue;
            return (T)((NodeProperty)clazz.cast(p));
        }
        return null;
    }

    @CheckForNull
    public NodeProperty getNodeProperty(String className) {
        for (NodeProperty p : this.getNodeProperties()) {
            if (!p.getClass().getName().equals(className)) continue;
            return p;
        }
        return null;
    }

    public List<NodePropertyDescriptor> getNodePropertyDescriptors() {
        return NodeProperty.for_(this);
    }

    @Override
    public ACL getACL() {
        return Jenkins.get().getAuthorizationStrategy().getACL(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node reconfigure(final StaplerRequest req, JSONObject form) throws Descriptor.FormException {
        if (form == null) {
            return null;
        }
        final JSONObject jsonForProperties = form.optJSONObject("nodeProperties");
        final AtomicReference<BindInterceptor> old = new AtomicReference<BindInterceptor>();
        old.set(req.setBindInterceptor(new BindInterceptor(){

            public Object onConvert(Type targetType, Class targetTypeErasure, Object jsonSource) {
                if (jsonForProperties != jsonSource) {
                    return ((BindInterceptor)old.get()).onConvert(targetType, targetTypeErasure, jsonSource);
                }
                try {
                    DescribableList tmp = new DescribableList(Saveable.NOOP, Node.this.getNodeProperties().toList());
                    tmp.rebuild(req, jsonForProperties, NodeProperty.all());
                    return tmp.toList();
                }
                catch (Descriptor.FormException | IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }));
        try {
            Node node = (Node)this.getDescriptor().newInstance(req, form);
            return node;
        }
        finally {
            req.setBindListener((BindInterceptor)old.get());
        }
    }

    public abstract NodeDescriptor getDescriptor();

    public ClockDifference getClockDifference() throws IOException, InterruptedException {
        VirtualChannel channel = this.getChannel();
        if (channel == null) {
            throw new IOException(this.getNodeName() + " is offline");
        }
        return (ClockDifference)channel.call(this.getClockDifferenceCallable());
    }

    public abstract Callable<ClockDifference, IOException> getClockDifferenceCallable();

    public static enum Mode {
        NORMAL(Messages._Node_Mode_NORMAL()),
        EXCLUSIVE(Messages._Node_Mode_EXCLUSIVE());

        private final Localizable description;

        public String getDescription() {
            return this.description.toString();
        }

        public String getName() {
            return this.name();
        }

        private Mode(Localizable description) {
            this.description = description;
        }

        static {
            Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), Mode.class);
        }
    }

    @Extension
    public static class InternalComputerListener
    extends ComputerListener {
        @Override
        public void onOnline(Computer c, TaskListener listener) {
            Node node = c.getNode();
            if (node != null && node.temporaryOfflineCause != null && node.temporaryOfflineCause != c.getOfflineCause()) {
                c.setTemporarilyOffline(true, node.temporaryOfflineCause);
            }
        }
    }
}

