/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.RunParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.util.EnumConverter;
import hudson.util.RunList;
import java.util.Objects;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.Converter;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.Exported;

public class RunParameterDefinition
extends SimpleParameterDefinition {
    private final String projectName;
    private final String runId;
    private final RunParameterFilter filter;
    private static final Logger LOGGER = Logger.getLogger(RunParameterDefinition.class.getName());

    @DataBoundConstructor
    public RunParameterDefinition(String name, String projectName, String description, RunParameterFilter filter) {
        super(name, description);
        this.projectName = projectName;
        this.runId = null;
        this.filter = filter;
    }

    @Deprecated
    public RunParameterDefinition(String name, String projectName, String description) {
        this(name, projectName, description, RunParameterFilter.ALL);
    }

    private RunParameterDefinition(String name, String projectName, String runId, String description, RunParameterFilter filter) {
        super(name, description);
        this.projectName = projectName;
        this.runId = runId;
        this.filter = filter;
    }

    @Override
    public ParameterDefinition copyWithDefaultValue(ParameterValue defaultValue) {
        if (defaultValue instanceof RunParameterValue) {
            RunParameterValue value = (RunParameterValue)defaultValue;
            return new RunParameterDefinition(this.getName(), this.getProjectName(), value.getRunId(), this.getDescription(), this.getFilter());
        }
        return this;
    }

    @Exported
    public String getProjectName() {
        return this.projectName;
    }

    public Job getProject() {
        return Jenkins.get().getItemByFullName(this.projectName, Job.class);
    }

    @Exported
    public RunParameterFilter getFilter() {
        return null == this.filter ? RunParameterFilter.ALL : this.filter;
    }

    public RunList getBuilds() {
        switch (this.getFilter()) {
            case COMPLETED: {
                return ((RunList)this.getProject().getBuilds()).overThresholdOnly(Result.ABORTED).completedOnly();
            }
            case SUCCESSFUL: {
                return ((RunList)this.getProject().getBuilds()).overThresholdOnly(Result.UNSTABLE).completedOnly();
            }
            case STABLE: {
                return ((RunList)this.getProject().getBuilds()).overThresholdOnly(Result.SUCCESS).completedOnly();
            }
        }
        return this.getProject().getBuilds();
    }

    @Override
    public ParameterValue getDefaultParameterValue() {
        Object lastBuild;
        if (this.runId != null) {
            return this.createValue(this.runId);
        }
        Job project = this.getProject();
        if (project == null) {
            return null;
        }
        switch (this.getFilter()) {
            case COMPLETED: {
                lastBuild = project.getLastCompletedBuild();
                break;
            }
            case SUCCESSFUL: {
                lastBuild = project.getLastSuccessfulBuild();
                break;
            }
            case STABLE: {
                lastBuild = project.getLastStableBuild();
                break;
            }
            default: {
                lastBuild = project.getLastBuild();
            }
        }
        if (lastBuild != null) {
            return this.createValue(((Run)lastBuild).getExternalizableId());
        }
        return null;
    }

    @Override
    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        RunParameterValue value = (RunParameterValue)req.bindJSON(RunParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    @Override
    public RunParameterValue createValue(String value) {
        return new RunParameterValue(this.getName(), value, this.getDescription());
    }

    @Override
    public int hashCode() {
        if (RunParameterDefinition.class != this.getClass()) {
            return super.hashCode();
        }
        return Objects.hash(new Object[]{this.getName(), this.getDescription(), this.projectName, this.runId, this.filter});
    }

    @Override
    public boolean equals(Object obj) {
        if (RunParameterDefinition.class != this.getClass()) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RunParameterDefinition other = (RunParameterDefinition)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDescription(), other.getDescription())) {
            return false;
        }
        if (!Objects.equals(this.projectName, other.projectName)) {
            return false;
        }
        if (!Objects.equals(this.runId, other.runId)) {
            return false;
        }
        return Objects.equals((Object)this.filter, (Object)other.filter);
    }

    @Extension
    @Symbol(value={"run", "runParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.RunParameterDefinition_DisplayName();
        }

        @Override
        public String getHelpFile() {
            return "/help/parameter/run.html";
        }

        @Override
        public ParameterDefinition newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (ParameterDefinition)req.bindJSON(RunParameterDefinition.class, formData);
        }

        public AutoCompletionCandidates doAutoCompleteProjectName(@QueryParameter String value) {
            return AutoCompletionCandidates.ofJobNames(Job.class, value, null, Jenkins.get());
        }
    }

    public static enum RunParameterFilter {
        ALL,
        STABLE,
        SUCCESSFUL,
        COMPLETED;


        public String getName() {
            return this.name();
        }

        static {
            Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), RunParameterFilter.class);
        }
    }
}

