/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.EnvVars;
import hudson.model.ParameterValue;
import hudson.model.Run;
import java.util.Locale;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class RunParameterValue
extends ParameterValue {
    private final String runId;

    @DataBoundConstructor
    public RunParameterValue(String name, String runId, String description) {
        super(name, description);
        this.runId = RunParameterValue.check(runId);
    }

    public RunParameterValue(String name, String runId) {
        super(name, null);
        this.runId = RunParameterValue.check(runId);
    }

    private static String check(String runId) {
        if (runId == null || runId.indexOf(35) == -1) {
            throw new IllegalArgumentException(runId);
        }
        return runId;
    }

    @CheckForNull
    public Run getRun() {
        return Run.fromExternalizableId(this.runId);
    }

    public String getRunId() {
        return this.runId;
    }

    private String[] split() {
        if (this.runId == null) {
            return null;
        }
        String[] r = this.runId.split("#");
        if (r.length != 2) {
            return null;
        }
        return r;
    }

    @Exported
    public String getJobName() {
        String[] r = this.split();
        return r == null ? null : r[0];
    }

    @Exported
    public String getNumber() {
        String[] r = this.split();
        return r == null ? null : r[1];
    }

    @Override
    public Run getValue() {
        return this.getRun();
    }

    @Override
    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        Run run = this.getRun();
        String value = null == run ? "UNKNOWN" : Jenkins.get().getRootUrl() + run.getUrl();
        env.put(this.name, value);
        env.put(this.name + ".jobName", this.getJobName());
        env.put(this.name + "_JOBNAME", this.getJobName());
        env.put(this.name + ".number", this.getNumber());
        env.put(this.name + "_NUMBER", this.getNumber());
        env.put(this.name + "_NAME", null == run ? "#" + this.getNumber() : run.getDisplayName());
        String buildResult = null == run || null == run.getResult() ? "UNKNOWN" : run.getResult().toString();
        env.put(this.name + "_RESULT", buildResult);
        env.put(this.name.toUpperCase(Locale.ENGLISH), value);
    }

    public String toString() {
        return "(RunParameterValue) " + this.getName() + "='" + this.getRunId() + "'";
    }

    @Override
    public String getShortDescription() {
        Run run = this.getRun();
        return this.name + "=" + (null == run ? this.getJobName() + " #" + this.getNumber() : run.getFullDisplayName());
    }
}

