/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.cli.CLI;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Messages;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.remoting.Which;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.NodeDescriptor;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.ClockDifference;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import jenkins.slaves.WorkspaceLocator;
import jenkins.util.SystemProperties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class Slave
extends Node
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(Slave.class.getName());
    protected String name;
    private String description;
    protected final String remoteFS;
    private int numExecutors = 1;
    private Node.Mode mode = Node.Mode.NORMAL;
    private RetentionStrategy retentionStrategy;
    private ComputerLauncher launcher;
    private String label = "";
    private DescribableList<NodeProperty<?>, NodePropertyDescriptor> nodeProperties = new DescribableList(this);
    @Deprecated
    private transient String userId;
    @Deprecated
    private transient String agentCommand;
    private static final String WORKSPACE_ROOT = SystemProperties.getString(Slave.class.getName() + ".workspaceRoot", "workspace");
    private static final Set<String> ALLOWED_JNLPJARS_FILES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("agent.jar", "slave.jar", "remoting.jar", "jenkins-cli.jar", "hudson-cli.jar")));

    @Deprecated
    public Slave(String name, String nodeDescription, String remoteFS, String numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties) throws Descriptor.FormException, IOException {
        this(name, nodeDescription, remoteFS, Util.tryParseNumber(numExecutors, 1).intValue(), mode, labelString, launcher, retentionStrategy, nodeProperties);
    }

    @Deprecated
    public Slave(String name, String nodeDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy retentionStrategy) throws Descriptor.FormException, IOException {
        this(name, nodeDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, new ArrayList());
    }

    public Slave(@NonNull String name, String remoteFS, ComputerLauncher launcher) throws Descriptor.FormException, IOException {
        this.name = name;
        this.remoteFS = remoteFS;
        this.launcher = launcher;
    }

    @Deprecated
    public Slave(@NonNull String name, String nodeDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy retentionStrategy, List<? extends NodeProperty<?>> nodeProperties) throws Descriptor.FormException, IOException {
        this.name = name;
        this.description = nodeDescription;
        this.numExecutors = numExecutors;
        this.mode = mode;
        this.remoteFS = Util.fixNull(remoteFS).trim();
        this.label = Util.fixNull(labelString).trim();
        this.launcher = launcher;
        this.retentionStrategy = retentionStrategy;
        this.getAssignedLabels();
        this.nodeProperties.replaceBy(nodeProperties);
        if (name.equals("")) {
            throw new Descriptor.FormException(Messages.Slave_InvalidConfig_NoName(), null);
        }
        if (this.numExecutors <= 0) {
            throw new Descriptor.FormException(Messages.Slave_InvalidConfig_Executors(name), null);
        }
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.220")
    public String getUserId() {
        return this.userId;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    @RestrictedSince(value="2.220")
    public void setUserId(String userId) {
    }

    public ComputerLauncher getLauncher() {
        if (this.launcher == null && !StringUtils.isEmpty((String)this.agentCommand)) {
            try {
                this.launcher = (ComputerLauncher)Jenkins.get().getPluginManager().uberClassLoader.loadClass("hudson.slaves.CommandLauncher").getConstructor(String.class, EnvVars.class).newInstance(this.agentCommand, null);
                this.agentCommand = null;
                this.save();
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "could not update historical agentCommand setting to CommandLauncher", x);
            }
        }
        return this.launcher == null ? new JNLPLauncher(false) : this.launcher;
    }

    public void setLauncher(ComputerLauncher launcher) {
        this.launcher = launcher;
    }

    public String getRemoteFS() {
        return this.remoteFS;
    }

    @Override
    public String getNodeName() {
        return this.name;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }

    @Override
    public void setNodeName(String name) {
        this.name = name;
    }

    @DataBoundSetter
    public void setNodeDescription(String value) {
        this.description = value;
    }

    @Override
    public String getNodeDescription() {
        return this.description;
    }

    @Override
    public int getNumExecutors() {
        return this.numExecutors;
    }

    @DataBoundSetter
    public void setNumExecutors(int n) {
        this.numExecutors = n;
    }

    @Override
    public Node.Mode getMode() {
        return this.mode;
    }

    @DataBoundSetter
    public void setMode(Node.Mode mode) {
        this.mode = mode;
    }

    @Override
    public DescribableList<NodeProperty<?>, NodePropertyDescriptor> getNodeProperties() {
        assert (this.nodeProperties != null);
        return this.nodeProperties;
    }

    @DataBoundSetter
    public void setNodeProperties(List<? extends NodeProperty<?>> properties) throws IOException {
        this.nodeProperties.replaceBy(properties);
    }

    public RetentionStrategy getRetentionStrategy() {
        return this.retentionStrategy == null ? RetentionStrategy.Always.INSTANCE : this.retentionStrategy;
    }

    @DataBoundSetter
    public void setRetentionStrategy(RetentionStrategy availabilityStrategy) {
        this.retentionStrategy = availabilityStrategy;
    }

    @Override
    public String getLabelString() {
        return Util.fixNull(this.label).trim();
    }

    @Override
    @DataBoundSetter
    public void setLabelString(String labelString) throws IOException {
        this.label = Util.fixNull(labelString).trim();
        this.getAssignedLabels();
    }

    @Override
    public Callable<ClockDifference, IOException> getClockDifferenceCallable() {
        return new GetClockDifference1();
    }

    @Override
    public Computer createComputer() {
        return new SlaveComputer(this);
    }

    @Override
    public FilePath getWorkspaceFor(TopLevelItem item) {
        for (WorkspaceLocator l : WorkspaceLocator.all()) {
            FilePath workspace = l.locate(item, this);
            if (workspace == null) continue;
            return workspace;
        }
        FilePath r = this.getWorkspaceRoot();
        if (r == null) {
            return null;
        }
        return r.child(item.getFullName());
    }

    @Override
    @CheckForNull
    public FilePath getRootPath() {
        SlaveComputer computer = this.getComputer();
        if (computer == null) {
            return null;
        }
        return this.createPath(StringUtils.defaultString((String)computer.getAbsoluteRemoteFs(), (String)this.remoteFS));
    }

    @CheckForNull
    public FilePath getWorkspaceRoot() {
        FilePath r = this.getRootPath();
        if (r == null) {
            return null;
        }
        return r.child(WORKSPACE_ROOT);
    }

    @Override
    @NonNull
    public Launcher createLauncher(TaskListener listener) {
        SlaveComputer c = this.getComputer();
        if (c == null) {
            listener.error("Issue with creating launcher for agent " + this.name + ". Computer has been disconnected");
            return new Launcher.DummyLauncher(listener);
        }
        Slave node = c.getNode();
        if (node != this) {
            String message = "Issue with creating launcher for agent " + this.name + ". Computer has been reconnected";
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, message, new IllegalStateException("Computer has been reconnected, this Node instance cannot be used anymore"));
            }
            return new Launcher.DummyLauncher(listener);
        }
        Channel channel = c.getChannel();
        if (channel == null) {
            this.reportLauncherCreateError("The agent has not been fully initialized yet", "No remoting channel to the agent OR it has not been fully initialized yet", listener);
            return new Launcher.DummyLauncher(listener);
        }
        if (channel.isClosingOrClosed()) {
            this.reportLauncherCreateError("The agent is being disconnected", "Remoting channel is either in the process of closing down or has closed down", listener);
            return new Launcher.DummyLauncher(listener);
        }
        Boolean isUnix = c.isUnix();
        if (isUnix == null) {
            this.reportLauncherCreateError("The agent has not been fully initialized yet", "Cannot determine if the agent is a Unix one, the System status request has not completed yet. It is an invalid channel state, please report a bug to Jenkins if you see it.", listener);
            return new Launcher.DummyLauncher(listener);
        }
        return new Launcher.RemoteLauncher(listener, (VirtualChannel)channel, isUnix).decorateFor(this);
    }

    private void reportLauncherCreateError(@NonNull String humanReadableMsg, @CheckForNull String exceptionDetails, @NonNull TaskListener listener) {
        String message = "Issue with creating launcher for agent " + this.name + ". " + humanReadableMsg;
        listener.error(message);
        if (LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, message + "Probably there is a race condition with Agent reconnection or disconnection, check other log entries", new IllegalStateException(exceptionDetails != null ? exceptionDetails : humanReadableMsg));
        }
    }

    @CheckForNull
    public SlaveComputer getComputer() {
        return (SlaveComputer)this.toComputer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Slave that = (Slave)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    protected Object readResolve() {
        if (this.nodeProperties == null) {
            this.nodeProperties = new DescribableList(this);
        }
        return this;
    }

    @Override
    public SlaveDescriptor getDescriptor() {
        Descriptor d = Jenkins.get().getDescriptorOrDie(this.getClass());
        if (d instanceof SlaveDescriptor) {
            return (SlaveDescriptor)d;
        }
        throw new IllegalStateException(d.getClass() + " needs to extend from SlaveDescriptor");
    }

    private static final class GetClockDifference3
    implements Serializable {
        private final long remoteTime = System.currentTimeMillis();
        private final long startTime;

        GetClockDifference3(long startTime) {
            this.startTime = startTime;
        }

        private Object readResolve() {
            long endTime = System.currentTimeMillis();
            return new ClockDifference((this.startTime + endTime) / 2L - this.remoteTime);
        }
    }

    private static final class GetClockDifference2
    extends MasterToSlaveCallable<GetClockDifference3, IOException> {
        private final long startTime = System.currentTimeMillis();
        private static final long serialVersionUID = 1L;

        private GetClockDifference2() {
        }

        public GetClockDifference3 call() {
            return new GetClockDifference3(this.startTime);
        }
    }

    private static final class GetClockDifference1
    extends MasterToSlaveCallable<ClockDifference, IOException> {
        private static final long serialVersionUID = 1L;

        private GetClockDifference1() {
        }

        public ClockDifference call() {
            return new ClockDifference(0L);
        }

        private Object writeReplace() {
            return new GetClockDifference2();
        }
    }

    public static abstract class SlaveDescriptor
    extends NodeDescriptor {
        public FormValidation doCheckNumExecutors(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger(value);
        }

        public FormValidation doCheckRemoteFS(@QueryParameter String value) throws IOException, ServletException {
            if (Util.fixEmptyAndTrim(value) == null) {
                return FormValidation.error(Messages.Slave_Remote_Director_Mandatory());
            }
            if (value.startsWith("\\\\") || value.startsWith("/net/")) {
                return FormValidation.warning(Messages.Slave_Network_Mounted_File_System_Warning());
            }
            if (Util.isRelativePath(value)) {
                return FormValidation.warning(Messages.Slave_Remote_Relative_Path_Warning());
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public final List<Descriptor<ComputerLauncher>> computerLauncherDescriptors(@CheckForNull Slave it) {
            DescriptorExtensionList all = Jenkins.get().getDescriptorList(ComputerLauncher.class);
            return it == null ? DescriptorVisibilityFilter.applyType(this.clazz, all) : DescriptorVisibilityFilter.apply(it, all);
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public final List<Descriptor<RetentionStrategy<?>>> retentionStrategyDescriptors(@CheckForNull Slave it) {
            return it == null ? DescriptorVisibilityFilter.applyType(this.clazz, RetentionStrategy.all()) : DescriptorVisibilityFilter.apply(it, RetentionStrategy.all());
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public final List<NodePropertyDescriptor> nodePropertyDescriptors(@CheckForNull Slave it) {
            ArrayList<NodePropertyDescriptor> result = new ArrayList<NodePropertyDescriptor>();
            DescriptorExtensionList list = Jenkins.get().getDescriptorList(NodeProperty.class);
            for (NodePropertyDescriptor npd : it == null ? DescriptorVisibilityFilter.applyType(this.clazz, list) : DescriptorVisibilityFilter.apply(it, list)) {
                if (!npd.isApplicable(this.clazz)) continue;
                result.add(npd);
            }
            return result;
        }
    }

    public static final class JnlpJar
    implements HttpResponse {
        private final String fileName;

        public JnlpJar(String fileName) {
            this.fileName = fileName;
        }

        public void doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
            URLConnection con = this.connect();
            rsp.setHeader("Content-Disposition", "attachment; filename=" + this.fileName);
            try (InputStream in = con.getInputStream();){
                rsp.serveFile(req, in, con.getLastModified(), con.getContentLengthLong(), "*.jar");
            }
        }

        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            this.doIndex(req, rsp);
        }

        private URLConnection connect() throws IOException {
            URL res = this.getURL();
            return res.openConnection();
        }

        public URL getURL() throws IOException {
            URL res;
            String name = this.fileName;
            if (!ALLOWED_JNLPJARS_FILES.contains(name)) {
                throw new MalformedURLException("The specified file path " + this.fileName + " is not allowed due to security reasons");
            }
            Class<CLI> owner = null;
            if (name.equals("hudson-cli.jar") || name.equals("jenkins-cli.jar")) {
                owner = CLI.class;
            } else if (name.equals("agent.jar") || name.equals("slave.jar") || name.equals("remoting.jar")) {
                owner = hudson.remoting.Launcher.class;
            }
            if (owner != null) {
                File jar = Which.jarFile(owner);
                if (jar.isFile()) {
                    name = "lib/" + jar.getName();
                } else {
                    URL res2 = this.findExecutableJar(jar, owner);
                    if (res2 != null) {
                        return res2;
                    }
                }
            }
            if ((res = Jenkins.get().servletContext.getResource("/WEB-INF/" + name)) == null) {
                throw new FileNotFoundException(name);
            }
            LOGGER.log(Level.FINE, "found {0}", res);
            return res;
        }

        @CheckForNull
        private URL findExecutableJar(File notActuallyJAR, Class<?> mainClass) throws IOException {
            File[] siblings;
            if (notActuallyJAR.getName().equals("classes") && (siblings = notActuallyJAR.getParentFile().listFiles()) != null) {
                for (File actualJar : siblings) {
                    if (!actualJar.getName().endsWith(".jar")) continue;
                    try (JarFile jf = new JarFile(actualJar, false);){
                        Manifest mf = jf.getManifest();
                        if (mf == null || !mainClass.getName().equals(mf.getMainAttributes().getValue("Main-Class"))) continue;
                        LOGGER.log(Level.FINE, "found {0}", actualJar);
                        URL uRL = actualJar.toURI().toURL();
                        return uRL;
                    }
                }
            }
            return null;
        }

        public byte[] readFully() throws IOException {
            try (InputStream in = this.connect().getInputStream();){
                byte[] byArray = IOUtils.toByteArray((InputStream)in);
                return byArray;
            }
        }
    }
}

