/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import hudson.model.Computer;
import hudson.node_monitors.AbstractNodeMonitorDescriptor;
import hudson.node_monitors.DiskSpaceMonitorDescriptor;
import hudson.node_monitors.Messages;
import hudson.node_monitors.NodeMonitor;
import java.text.ParseException;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class AbstractDiskSpaceMonitor
extends NodeMonitor {
    public final String freeSpaceThreshold;
    private static final Logger LOGGER = Logger.getLogger(AbstractDiskSpaceMonitor.class.getName());
    private static final long DEFAULT_THRESHOLD = 0x40000000L;

    public AbstractDiskSpaceMonitor(String threshold) throws ParseException {
        this.freeSpaceThreshold = threshold;
        DiskSpaceMonitorDescriptor.DiskSpace.parse(threshold);
    }

    public AbstractDiskSpaceMonitor() {
        this.freeSpaceThreshold = "1GB";
    }

    public long getThresholdBytes() {
        if (this.freeSpaceThreshold == null) {
            return 0x40000000L;
        }
        try {
            return DiskSpaceMonitorDescriptor.DiskSpace.parse((String)this.freeSpaceThreshold).size;
        }
        catch (ParseException e) {
            return 0x40000000L;
        }
    }

    @Override
    public Object data(Computer c) {
        DiskSpaceMonitorDescriptor.DiskSpace size = this.markNodeOfflineIfDiskspaceIsTooLow(c);
        if (size != null && size.size > this.getThresholdBytes() && c.isOffline() && c.getOfflineCause() instanceof DiskSpaceMonitorDescriptor.DiskSpace && this.getClass().equals(((DiskSpaceMonitorDescriptor.DiskSpace)c.getOfflineCause()).getTrigger()) && ((AbstractNodeMonitorDescriptor)this.getDescriptor()).markOnline(c)) {
            LOGGER.info(Messages.DiskSpaceMonitor_MarkedOnline(c.getDisplayName()));
        }
        return size;
    }

    @Restricted(value={NoExternalUse.class})
    public DiskSpaceMonitorDescriptor.DiskSpace markNodeOfflineIfDiskspaceIsTooLow(Computer c) {
        DiskSpaceMonitorDescriptor.DiskSpace size = (DiskSpaceMonitorDescriptor.DiskSpace)super.data(c);
        if (size != null && size.size < this.getThresholdBytes()) {
            size.setTriggered(this.getClass(), true);
            if (((AbstractNodeMonitorDescriptor)this.getDescriptor()).markOffline(c, size)) {
                LOGGER.warning(Messages.DiskSpaceMonitor_MarkedOffline(c.getDisplayName()));
            }
        }
        return size;
    }
}

