/*
 * Decompiled with CFR 0.152.
 */
package hudson.node_monitors;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.node_monitors.AbstractDiskSpaceMonitor;
import hudson.node_monitors.DiskSpaceMonitorDescriptor;
import hudson.node_monitors.Messages;
import hudson.remoting.Callable;
import java.io.IOException;
import java.text.ParseException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class DiskSpaceMonitor
extends AbstractDiskSpaceMonitor {
    public static final DiskSpaceMonitorDescriptor DESCRIPTOR = new DiskSpaceMonitorDescriptor(){

        @Override
        public String getDisplayName() {
            return Messages.DiskSpaceMonitor_DisplayName();
        }

        @Override
        protected Callable<DiskSpaceMonitorDescriptor.DiskSpace, IOException> createCallable(Computer c) {
            Node node = c.getNode();
            if (node == null) {
                return null;
            }
            FilePath p = node.getRootPath();
            if (p == null) {
                return null;
            }
            return p.asCallableWith(new DiskSpaceMonitorDescriptor.GetUsableSpace());
        }
    };

    @DataBoundConstructor
    public DiskSpaceMonitor(String freeSpaceThreshold) throws ParseException {
        super(freeSpaceThreshold);
    }

    public DiskSpaceMonitor() {
    }

    public DiskSpaceMonitorDescriptor.DiskSpace getFreeSpace(Computer c) {
        return (DiskSpaceMonitorDescriptor.DiskSpace)DESCRIPTOR.get(c);
    }

    @Override
    public String getColumnCaption() {
        return Jenkins.get().hasPermission(Jenkins.ADMINISTER) ? super.getColumnCaption() : null;
    }

    @Extension
    public static DiskSpaceMonitorDescriptor install() {
        return DESCRIPTOR;
    }
}

