/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.util.ErrorObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import jenkins.util.groovy.GroovyHookScript;
import org.kohsuke.stapler.WebApp;

public abstract class BootFailure
extends ErrorObject {
    private static final Logger LOGGER = Logger.getLogger(BootFailure.class.getName());

    protected BootFailure() {
    }

    protected BootFailure(Throwable cause) {
        super(cause);
    }

    public void publish(ServletContext context, @CheckForNull File home) {
        LOGGER.log(Level.SEVERE, "Failed to initialize Jenkins", this);
        WebApp.get((ServletContext)context).setApp((Object)this);
        if (home == null) {
            return;
        }
        new GroovyHookScript("boot-failure", context, home, BootFailure.class.getClassLoader()).bind("exception", this).bind("home", home).bind("servletContext", context).bind("attempts", this.loadAttempts(home)).run();
    }

    protected List<Date> loadAttempts(File home) {
        ArrayList<Date> dates;
        block18: {
            dates = new ArrayList<Date>();
            if (home != null) {
                File f = BootFailure.getBootFailureFile(home);
                try {
                    if (!f.exists()) break block18;
                    try (BufferedReader failureFileReader = new BufferedReader(new FileReader(f));){
                        String line;
                        while ((line = failureFileReader.readLine()) != null) {
                            try {
                                dates.add(new Date(line));
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to parse " + f, e);
                }
            }
        }
        return dates;
    }

    public static File getBootFailureFile(File home) {
        return new File(home, "failed-boot-attempts.txt");
    }
}

