/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.kohsuke.stapler.ClassDescriptor;

public class ReflectionUtils
extends org.springframework.util.ReflectionUtils {
    private static final Map<Class<?>, Object> defaultPrimitiveValue = new HashMap();

    public static Method getPublicMethodNamed(Class c, String methodName) {
        for (Method m : c.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    public static List<Parameter> getParameters(Method m) {
        return new MethodInfo(m);
    }

    public static Object getPublicProperty(Object o, String p) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        PropertyDescriptor pd = PropertyUtils.getPropertyDescriptor((Object)o, (String)p);
        if (pd == null) {
            try {
                Field f = o.getClass().getField(p);
                return f.get(o);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("No such property " + p + " on " + o.getClass());
            }
        }
        return PropertyUtils.getProperty((Object)o, (String)p);
    }

    @CheckForNull
    public static Object getVmDefaultValueForPrimitiveType(Class<?> type) {
        return defaultPrimitiveValue.get(type);
    }

    static {
        defaultPrimitiveValue.put(Boolean.TYPE, false);
        defaultPrimitiveValue.put(Character.TYPE, Character.valueOf('\u0000'));
        defaultPrimitiveValue.put(Byte.TYPE, (byte)0);
        defaultPrimitiveValue.put(Short.TYPE, (short)0);
        defaultPrimitiveValue.put(Integer.TYPE, 0);
        defaultPrimitiveValue.put(Long.TYPE, 0L);
        defaultPrimitiveValue.put(Float.TYPE, Float.valueOf(0.0f));
        defaultPrimitiveValue.put(Double.TYPE, 0.0);
        defaultPrimitiveValue.put(Void.TYPE, null);
    }

    public static final class Parameter
    implements AnnotatedElement {
        private final MethodInfo parent;
        private final int index;

        public Parameter(MethodInfo parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public int index() {
            return this.index;
        }

        public Class<?> type() {
            return this.parent.types[this.index];
        }

        public Type genericType() {
            return this.parent.genericTypes()[this.index];
        }

        public Annotation[] annotations() {
            return this.parent.annotations()[this.index];
        }

        public <A extends Annotation> A annotation(Class<A> type) {
            for (Annotation a : this.annotations()) {
                if (a.annotationType() != type) continue;
                return (A)((Annotation)type.cast(a));
            }
            return null;
        }

        public String name() {
            String[] names = this.parent.names();
            if (this.index < names.length) {
                return names[this.index];
            }
            return null;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> type) {
            return this.annotation(type) != null;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> type) {
            return this.annotation(type);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.annotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.annotations();
        }
    }

    private static final class MethodInfo
    extends AbstractList<Parameter> {
        private final Method method;
        private final Class<?>[] types;
        private Type[] genericTypes;
        private Annotation[][] annotations;
        private String[] names;

        private MethodInfo(Method method) {
            this.method = method;
            this.types = method.getParameterTypes();
        }

        @Override
        public Parameter get(int index) {
            return new Parameter(this, index);
        }

        @Override
        public int size() {
            return this.types.length;
        }

        public Type[] genericTypes() {
            if (this.genericTypes == null) {
                this.genericTypes = this.method.getGenericParameterTypes();
            }
            return this.genericTypes;
        }

        public Annotation[][] annotations() {
            if (this.annotations == null) {
                this.annotations = this.method.getParameterAnnotations();
            }
            return this.annotations;
        }

        public String[] names() {
            if (this.names == null) {
                this.names = ClassDescriptor.loadParameterNames((Method)this.method);
            }
            return this.names;
        }
    }
}

