/*
 * Decompiled with CFR 0.152.
 */
package jenkins;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.remoting.Channel;
import hudson.remoting.ChannelBuilder;
import java.io.File;
import jenkins.FilePathFilterAggregator;

public abstract class FilePathFilter {
    public static final FilePathFilter UNRESTRICTED = new FilePathFilterAggregator(){

        @Override
        protected boolean defaultAction() throws SecurityException {
            return true;
        }

        @Override
        public void add(FilePathFilter f, double d) {
        }

        @Override
        public String toString() {
            return "Unrestricted";
        }
    };

    public boolean read(File f) throws SecurityException {
        return false;
    }

    public boolean write(File f) throws SecurityException {
        return false;
    }

    public boolean symlink(File f) throws SecurityException {
        return false;
    }

    public boolean mkdirs(File f) throws SecurityException {
        return false;
    }

    public boolean create(File f) throws SecurityException {
        return false;
    }

    public boolean delete(File f) throws SecurityException {
        return false;
    }

    public boolean stat(File f) throws SecurityException {
        return false;
    }

    public final void installTo(ChannelBuilder cb) {
        this.installTo(cb, 0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void installTo(ChannelBuilder cb, double d) {
        ChannelBuilder channelBuilder = cb;
        synchronized (channelBuilder) {
            FilePathFilterAggregator filters = (FilePathFilterAggregator)cb.getProperties().get(FilePathFilterAggregator.KEY);
            if (filters == null) {
                filters = new FilePathFilterAggregator();
                cb.withProperty(FilePathFilterAggregator.KEY, (Object)filters);
            }
            filters.add(this, d);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void uninstallFrom(Channel ch) {
        Channel channel = ch;
        synchronized (channel) {
            FilePathFilterAggregator filters = (FilePathFilterAggregator)ch.getProperty(FilePathFilterAggregator.KEY);
            if (filters != null) {
                filters.remove(this);
            }
        }
    }

    @CheckForNull
    public static FilePathFilter current() {
        Channel ch = Channel.current();
        if (ch == null) {
            return null;
        }
        return (FilePathFilter)ch.getProperty(FilePathFilterAggregator.KEY);
    }
}

