/*
 * Decompiled with CFR 0.152.
 */
package jenkins.agents;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Computer;
import hudson.model.InvisibleAction;
import hudson.model.UnprotectedRootAction;
import hudson.remoting.AbstractByteBufferCommandTransport;
import hudson.remoting.Capability;
import hudson.remoting.ChannelBuilder;
import hudson.remoting.ChunkHeader;
import hudson.remoting.CommandTransport;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.slaves.JnlpAgentReceiver;
import jenkins.slaves.RemotingVersionInfo;
import jenkins.websocket.WebSocketSession;
import jenkins.websocket.WebSockets;
import org.jenkinsci.remoting.engine.JnlpConnectionState;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
@Restricted(value={NoExternalUse.class})
public final class WebSocketAgents
extends InvisibleAction
implements UnprotectedRootAction {
    private static final Logger LOGGER = Logger.getLogger(WebSocketAgents.class.getName());

    @Override
    public String getUrlName() {
        return WebSockets.isSupported() ? "wsagents" : null;
    }

    public HttpResponse doIndex(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String agent = req.getHeader("Node-Name");
        String secret = req.getHeader("Secret-Key");
        String remoteCapabilityStr = req.getHeader("X-Remoting-Capability");
        if (agent == null || secret == null || remoteCapabilityStr == null) {
            LOGGER.warning(() -> "incomplete headers: " + Collections.list(req.getHeaderNames()));
            throw HttpResponses.errorWithoutStack((int)400, (String)"This endpoint is only for use from agent.jar in WebSocket mode");
        }
        LOGGER.fine(() -> "receiving headers: " + Collections.list(req.getHeaderNames()));
        if (!JnlpAgentReceiver.DATABASE.exists(agent)) {
            LOGGER.warning(() -> "no such agent " + agent);
            throw HttpResponses.errorWithoutStack((int)400, (String)"no such agent");
        }
        if (!MessageDigest.isEqual(secret.getBytes(StandardCharsets.US_ASCII), JnlpAgentReceiver.DATABASE.getSecretOf(agent).getBytes(StandardCharsets.US_ASCII))) {
            LOGGER.warning(() -> "incorrect secret for " + agent);
            throw HttpResponses.forbidden();
        }
        JnlpConnectionState state = new JnlpConnectionState(null, ExtensionList.lookup(JnlpAgentReceiver.class));
        state.setRemoteEndpointDescription(req.getRemoteAddr());
        state.fireBeforeProperties();
        LOGGER.fine(() -> "connecting " + agent);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Node-Name", agent);
        properties.put("Secret-Key", secret);
        state.fireAfterProperties(Collections.unmodifiableMap(properties));
        Capability remoteCapability = Capability.fromASCII((String)remoteCapabilityStr);
        LOGGER.fine(() -> "received " + remoteCapability);
        rsp.setHeader("X-Remoting-Capability", new Capability().toASCII());
        rsp.setHeader("X-Remoting-Minimum-Version", RemotingVersionInfo.getMinimumSupportedVersion().toString());
        rsp.setHeader("JnlpAgentProtocol.cookie", JnlpAgentReceiver.generateCookie());
        return WebSockets.upgrade(new Session(state, agent, remoteCapability));
    }

    private static class Session
    extends WebSocketSession {
        private final JnlpConnectionState state;
        private final String agent;
        private final Capability remoteCapability;
        private Transport transport;

        Session(JnlpConnectionState state, String agent, Capability remoteCapability) {
            this.state = state;
            this.agent = agent;
            this.remoteCapability = remoteCapability;
        }

        @Override
        protected void opened() {
            Computer.threadPoolForRemoting.submit(() -> {
                LOGGER.fine(() -> "setting up channel for " + this.agent);
                this.state.fireBeforeChannel(new ChannelBuilder(this.agent, Computer.threadPoolForRemoting));
                this.transport = new Transport();
                this.state.fireAfterChannel(this.state.getChannelBuilder().build((CommandTransport)this.transport));
                LOGGER.fine(() -> "set up channel for " + this.agent);
                return null;
            });
        }

        @Override
        protected void binary(byte[] payload, int offset, int len) {
            LOGGER.finest(() -> "reading block of length " + len + " from " + this.agent);
            try {
                this.transport.receive(ByteBuffer.wrap(payload, offset, len));
            }
            catch (IOException | InterruptedException e) {
                this.error(e);
            }
        }

        @Override
        protected void closed(int statusCode, String reason) {
            LOGGER.finest(() -> "closed " + statusCode + " " + reason);
            ClosedChannelException x = new ClosedChannelException();
            this.transport.terminate(x);
            this.state.fireChannelClosed((IOException)x);
            this.state.fireAfterDisconnect();
        }

        @Override
        protected void error(Throwable cause) {
            LOGGER.log(Level.WARNING, null, cause);
        }

        class Transport
        extends AbstractByteBufferCommandTransport {
            Transport() {
            }

            protected void write(ByteBuffer header, ByteBuffer data) throws IOException {
                LOGGER.finest(() -> "sending message of length " + ChunkHeader.length((int)ChunkHeader.peek((ByteBuffer)header)));
                Session.this.sendBinary(header, false);
                Session.this.sendBinary(data, true);
            }

            public Capability getRemoteCapability() throws IOException {
                return Session.this.remoteCapability;
            }

            public void closeWrite() throws IOException {
                LOGGER.finest(() -> "closeWrite");
                Session.this.close();
            }

            public void closeRead() throws IOException {
                LOGGER.finest(() -> "closeRead");
                Session.this.close();
            }
        }
    }
}

