/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Node;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class NodeListener
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(NodeListener.class.getName());

    protected void onCreated(@NonNull Node node) {
    }

    protected void onUpdated(@NonNull Node oldOne, @NonNull Node newOne) {
    }

    protected void onDeleted(@NonNull Node node) {
    }

    public static void fireOnCreated(@NonNull Node node) {
        for (NodeListener nl : NodeListener.all()) {
            try {
                nl.onCreated(node);
            }
            catch (Throwable ex) {
                LOGGER.log(Level.WARNING, "Listener invocation failed", ex);
            }
        }
    }

    public static void fireOnUpdated(@NonNull Node oldOne, @NonNull Node newOne) {
        for (NodeListener nl : NodeListener.all()) {
            try {
                nl.onUpdated(oldOne, newOne);
            }
            catch (Throwable ex) {
                LOGGER.log(Level.WARNING, "Listener invocation failed", ex);
            }
        }
    }

    public static void fireOnDeleted(@NonNull Node node) {
        for (NodeListener nl : NodeListener.all()) {
            try {
                nl.onDeleted(node);
            }
            catch (Throwable ex) {
                LOGGER.log(Level.WARNING, "Listener invocation failed", ex);
            }
        }
    }

    @NonNull
    public static List<NodeListener> all() {
        return ExtensionList.lookup(NodeListener.class);
    }
}

