/*
 * Decompiled with CFR 0.152.
 */
package jenkins.mvn;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.util.IOUtils;
import java.io.File;
import java.io.IOException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
class SettingsPathHelper {
    SettingsPathHelper() {
    }

    static FilePath getSettings(AbstractBuild<?, ?> build, TaskListener listener, String path) throws IOException, InterruptedException {
        EnvVars env = build.getEnvironment(listener);
        String targetPath = Util.replaceMacro(path, build.getBuildVariableResolver());
        if (IOUtils.isAbsolute(targetPath = env.expand(targetPath))) {
            return new FilePath(new File(targetPath));
        }
        FilePath mrSettings = build.getModuleRoot().child(targetPath);
        FilePath wsSettings = build.getWorkspace().child(targetPath);
        try {
            if (!wsSettings.exists() && mrSettings.exists()) {
                wsSettings = mrSettings;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to find settings.xml at: " + wsSettings.getRemote());
        }
        return wsSettings;
    }
}

