/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import hudson.model.DirectoryBrowserSupport;
import hudson.security.Permission;
import hudson.util.HttpResponses;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.security.Messages;
import jenkins.security.ResourceDomainConfiguration;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Restricted(value={NoExternalUse.class})
public class ResourceDomainRecommendation
extends AdministrativeMonitor {
    @Override
    public String getDisplayName() {
        return Messages.ResourceDomainConfiguration_DisplayName();
    }

    @Override
    public boolean isActivated() {
        boolean isResourceRootUrlSet = ResourceDomainConfiguration.isResourceDomainConfigured();
        boolean isOverriddenCSP = SystemProperties.getString(DirectoryBrowserSupport.CSP_PROPERTY_NAME) != null;
        return isOverriddenCSP && !isResourceRootUrlSet;
    }

    @RequirePOST
    public HttpResponse doAct(@QueryParameter String redirect, @QueryParameter String dismiss) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (dismiss != null) {
            this.disable(true);
            return HttpResponses.redirectViaContextPath((String)"manage");
        }
        if (redirect != null) {
            return HttpResponses.redirectViaContextPath((String)"configure");
        }
        return HttpResponses.forwardToPreviousPage();
    }

    @Override
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }
}

