/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.s2m.ConfigFile;

abstract class ConfigDirectory<T, COL extends Collection<T>>
extends ConfigFile<T, COL> {
    private final File dir;
    private static final Logger LOGGER = Logger.getLogger(ConfigDirectory.class.getName());

    protected ConfigDirectory(File file) {
        super(file);
        this.dir = file.getParentFile();
    }

    @Override
    public synchronized void load() {
        Object[] fragments;
        Object result = this.create();
        if (this.dir.exists() && (fragments = this.dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".conf");
            }
        })) != null) {
            Arrays.sort(fragments);
            for (Object fragment : fragments) {
                File f = new File(this.dir, (String)fragment);
                try (BufferedReader reader = new BufferedReader(new FileReader(f));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        Object r;
                        if (line.startsWith("#") || (r = this.parse(line)) == null) continue;
                        result.add(r);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to parse " + f, e);
                }
            }
        }
        this.parsed = this.readOnly(result);
    }
}

