/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.stapler;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import jenkins.model.Jenkins;
import jenkins.security.stapler.StaplerFragments;
import jenkins.security.stapler.StaplerViews;
import jenkins.util.SystemProperties;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.CancelRequestHandlingException;
import org.kohsuke.stapler.DispatchValidator;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebApp;

@Restricted(value={NoExternalUse.class})
public class StaplerDispatchValidator
implements DispatchValidator {
    private static final Logger LOGGER = Logger.getLogger(StaplerDispatchValidator.class.getName());
    private static final String ATTRIBUTE_NAME = StaplerDispatchValidator.class.getName() + ".status";
    private static final String ESCAPE_HATCH = StaplerDispatchValidator.class.getName() + ".disabled";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean DISABLED = SystemProperties.getBoolean(ESCAPE_HATCH);
    private final ValidatorCache cache = new ValidatorCache();

    @CheckForNull
    private static Boolean setStatus(@NonNull StaplerRequest req, @CheckForNull Boolean status) {
        if (status == null) {
            return null;
        }
        LOGGER.fine(() -> "Request dispatch set status to " + status + " for URL " + req.getPathInfo());
        req.setAttribute(ATTRIBUTE_NAME, (Object)status);
        return status;
    }

    @CheckForNull
    private static Boolean computeStatusIfNull(@NonNull StaplerRequest req, @NonNull Supplier<Boolean> statusIfNull) {
        Object requestStatus = req.getAttribute(ATTRIBUTE_NAME);
        return requestStatus instanceof Boolean ? (Boolean)requestStatus : StaplerDispatchValidator.setStatus(req, statusIfNull.get());
    }

    public StaplerDispatchValidator() {
        this.cache.load();
    }

    @CheckForNull
    public Boolean isDispatchAllowed(@NonNull StaplerRequest req, @NonNull StaplerResponse rsp) {
        if (DISABLED) {
            return true;
        }
        Boolean status = StaplerDispatchValidator.computeStatusIfNull(req, () -> {
            if (rsp.getContentType() != null) {
                return true;
            }
            if (rsp.getStatus() >= 300) {
                return true;
            }
            return null;
        });
        LOGGER.finer(() -> req.getRequestURI() + " -> " + status);
        return status;
    }

    @CheckForNull
    public Boolean isDispatchAllowed(@NonNull StaplerRequest req, @NonNull StaplerResponse rsp, @NonNull String viewName, @CheckForNull Object node) {
        if (DISABLED) {
            return true;
        }
        Boolean status = StaplerDispatchValidator.computeStatusIfNull(req, () -> {
            if (viewName.equals("index")) {
                return true;
            }
            if (node == null) {
                return null;
            }
            return this.cache.find(node.getClass()).isViewValid(viewName);
        });
        LOGGER.finer(() -> "<" + req.getRequestURI() + ", " + viewName + ", " + node + "> -> " + status);
        return status;
    }

    public void allowDispatch(@NonNull StaplerRequest req, @NonNull StaplerResponse rsp) {
        if (DISABLED) {
            return;
        }
        StaplerDispatchValidator.setStatus(req, true);
    }

    public void requireDispatchAllowed(@NonNull StaplerRequest req, @NonNull StaplerResponse rsp) throws CancelRequestHandlingException {
        if (DISABLED) {
            return;
        }
        Boolean status = this.isDispatchAllowed(req, rsp);
        if (status == null || !status.booleanValue()) {
            LOGGER.fine(() -> "Cancelling dispatch for " + req.getRequestURI());
            throw new CancelRequestHandlingException();
        }
    }

    @VisibleForTesting
    static StaplerDispatchValidator getInstance(@NonNull ServletContext context) {
        return (StaplerDispatchValidator)WebApp.get((ServletContext)context).getDispatchValidator();
    }

    @VisibleForTesting
    void loadWhitelist(@NonNull InputStream in) throws IOException {
        this.cache.loadWhitelist(IOUtils.readLines((InputStream)in));
    }

    private static class ValidatorCache {
        private final Map<String, Validator> validators = new HashMap<String, Validator>();
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        private ValidatorCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private Validator computeIfAbsent(@NonNull String className, @NonNull Function<String, Validator> constructor) {
            this.lock.readLock().lock();
            try {
                if (this.validators.containsKey(className)) {
                    Validator validator = this.validators.get(className);
                    return validator;
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
            this.lock.writeLock().lock();
            try {
                if (this.validators.containsKey(className)) {
                    Validator validator = this.validators.get(className);
                    return validator;
                }
                Validator value = constructor.apply(className);
                this.validators.put(className, value);
                Validator validator = value;
                return validator;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @NonNull
        private Validator find(@NonNull Class<?> clazz) {
            return this.computeIfAbsent(clazz.getName(), name -> this.create(clazz));
        }

        @NonNull
        private Validator find(@NonNull String className) {
            return this.computeIfAbsent(className, this::create);
        }

        @NonNull
        private Collection<Validator> findParents(@NonNull Class<?> clazz) {
            ArrayList<Validator> parents = new ArrayList<Validator>();
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                parents.add(this.find(superclass));
            }
            for (Class<?> iface : clazz.getInterfaces()) {
                parents.add(this.find(iface));
            }
            return parents;
        }

        @NonNull
        private Validator create(@NonNull Class<?> clazz) {
            HashSet<String> allowed = new HashSet<String>();
            StaplerViews views = clazz.getDeclaredAnnotation(StaplerViews.class);
            if (views != null) {
                allowed.addAll(Arrays.asList(views.value()));
            }
            HashSet<String> denied = new HashSet<String>();
            StaplerFragments fragments = clazz.getDeclaredAnnotation(StaplerFragments.class);
            if (fragments != null) {
                denied.addAll(Arrays.asList(fragments.value()));
            }
            return new Validator(() -> this.findParents(clazz), allowed, denied);
        }

        @NonNull
        private Validator create(@NonNull String className) {
            ClassLoader loader = Jenkins.get().pluginManager.uberClassLoader;
            return new Validator(() -> {
                try {
                    return this.findParents(loader.loadClass(className));
                }
                catch (ClassNotFoundException e) {
                    LOGGER.log(Level.WARNING, e, () -> "Could not load class " + className + " to validate views");
                    return Collections.emptySet();
                }
            });
        }

        private void load() {
            Path configFile;
            try (InputStream is = Validator.class.getResourceAsStream("default-views-whitelist.txt");){
                this.loadWhitelist(IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Could not load default views whitelist", e);
            }
            String whitelist = SystemProperties.getString(StaplerDispatchValidator.class.getName() + ".whitelist");
            Path path = configFile = whitelist != null ? Paths.get(whitelist, new String[0]) : Jenkins.get().getRootDir().toPath().resolve("stapler-views-whitelist.txt");
            if (Files.exists(configFile, new LinkOption[0])) {
                try {
                    this.loadWhitelist(Files.readAllLines(configFile));
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e, () -> "Could not load user defined whitelist from " + configFile);
                }
            }
        }

        private void loadWhitelist(@NonNull List<String> whitelistLines) {
            for (String line : whitelistLines) {
                if (line.matches("#.*|\\s*")) continue;
                String[] parts = line.split("\\s+");
                if (parts.length < 2) {
                    LOGGER.warning(() -> "Cannot update validator with malformed line: " + line);
                    continue;
                }
                Validator validator = this.find(parts[0]);
                for (int i = 1; i < parts.length; ++i) {
                    String view = parts[i];
                    if (view.startsWith("!")) {
                        validator.denyView(view.substring(1));
                        continue;
                    }
                    validator.allowView(view);
                }
            }
        }

        private class Validator {
            private final Supplier<Collection<Validator>> parentsSupplier;
            private volatile Collection<Validator> parents;
            private final Set<String> allowed = ConcurrentHashMap.newKeySet();
            private final Set<String> denied = ConcurrentHashMap.newKeySet();

            private Validator(Supplier<Collection<Validator>> parentsSupplier) {
                this.parentsSupplier = parentsSupplier;
            }

            private Validator(@NonNull Supplier<Collection<Validator>> parentsSupplier, @NonNull Collection<String> allowed, Collection<String> denied) {
                this(parentsSupplier);
                this.allowed.addAll(allowed);
                this.denied.addAll(denied);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NonNull
            private Collection<Validator> getParents() {
                if (this.parents == null) {
                    Validator validator = this;
                    synchronized (validator) {
                        if (this.parents == null) {
                            this.parents = this.parentsSupplier.get();
                        }
                    }
                }
                return this.parents;
            }

            @CheckForNull
            private Boolean isViewValid(@NonNull String viewName) {
                if (this.allowed.contains(viewName)) {
                    return Boolean.TRUE;
                }
                if (this.denied.contains(viewName)) {
                    return Boolean.FALSE;
                }
                for (Validator parent : this.getParents()) {
                    Boolean result = parent.isViewValid(viewName);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }

            private void allowView(@NonNull String viewName) {
                this.allowed.add(viewName);
            }

            private void denyView(@NonNull String viewName) {
                this.denied.add(viewName);
            }
        }
    }
}

