/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.stapler;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Saveable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import jenkins.model.Jenkins;
import jenkins.security.stapler.RoutingDecisionProvider;
import jenkins.util.SystemProperties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.WebApp;

@Restricted(value={NoExternalUse.class})
@Extension
public class StaticRoutingDecisionProvider
extends RoutingDecisionProvider
implements Saveable {
    private static final Logger LOGGER = Logger.getLogger(StaticRoutingDecisionProvider.class.getName());
    private Set<String> whitelistSignaturesFromFixedList;
    private Set<String> whitelistSignaturesFromUserControlledList;
    private Set<String> blacklistSignaturesFromFixedList;
    private Set<String> blacklistSignaturesFromUserControlledList;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static String WHITELIST_PATH = SystemProperties.getString(StaticRoutingDecisionProvider.class.getName() + ".whitelist");

    public StaticRoutingDecisionProvider() {
        this.reload();
    }

    public static StaticRoutingDecisionProvider get() {
        return ExtensionList.lookupSingleton(StaticRoutingDecisionProvider.class);
    }

    @Override
    @NonNull
    public synchronized RoutingDecisionProvider.Decision decide(@NonNull String signature) {
        if (this.whitelistSignaturesFromFixedList == null || this.whitelistSignaturesFromUserControlledList == null || this.blacklistSignaturesFromFixedList == null || this.blacklistSignaturesFromUserControlledList == null) {
            this.reload();
        }
        LOGGER.log(Level.CONFIG, "Checking whitelist for " + signature);
        if (this.blacklistSignaturesFromFixedList.contains(signature) || this.blacklistSignaturesFromUserControlledList.contains(signature)) {
            return RoutingDecisionProvider.Decision.REJECTED;
        }
        if (this.whitelistSignaturesFromFixedList.contains(signature) || this.whitelistSignaturesFromUserControlledList.contains(signature)) {
            return RoutingDecisionProvider.Decision.ACCEPTED;
        }
        return RoutingDecisionProvider.Decision.UNKNOWN;
    }

    public synchronized void reload() {
        this.reloadFromDefault();
        this.reloadFromUserControlledList();
        this.resetMetaClassCache();
    }

    @VisibleForTesting
    synchronized void resetAndSave() {
        this.whitelistSignaturesFromFixedList = new HashSet<String>();
        this.whitelistSignaturesFromUserControlledList = new HashSet<String>();
        this.blacklistSignaturesFromFixedList = new HashSet<String>();
        this.blacklistSignaturesFromUserControlledList = new HashSet<String>();
        this.save();
    }

    private void resetMetaClassCache() {
        WebApp.get((ServletContext)Jenkins.get().servletContext).clearMetaClassCache();
    }

    private synchronized void reloadFromDefault() {
        try (InputStream is = StaticRoutingDecisionProvider.class.getResourceAsStream("default-whitelist.txt");){
            this.whitelistSignaturesFromFixedList = new HashSet<String>();
            this.blacklistSignaturesFromFixedList = new HashSet<String>();
            this.parseFileIntoList(IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8), this.whitelistSignaturesFromFixedList, this.blacklistSignaturesFromFixedList);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
        LOGGER.log(Level.FINE, "Found {0} getter in the standard whitelist", this.whitelistSignaturesFromFixedList.size());
    }

    public synchronized StaticRoutingDecisionProvider add(@NonNull String signature) {
        if (this.whitelistSignaturesFromUserControlledList.add(signature)) {
            LOGGER.log(Level.INFO, "Signature [{0}] added to the whitelist", signature);
            this.save();
            this.resetMetaClassCache();
        } else {
            LOGGER.log(Level.INFO, "Signature [{0}] was already present in the whitelist", signature);
        }
        return this;
    }

    public synchronized StaticRoutingDecisionProvider addBlacklistSignature(@NonNull String signature) {
        if (this.blacklistSignaturesFromUserControlledList.add(signature)) {
            LOGGER.log(Level.INFO, "Signature [{0}] added to the blacklist", signature);
            this.save();
            this.resetMetaClassCache();
        } else {
            LOGGER.log(Level.INFO, "Signature [{0}] was already present in the blacklist", signature);
        }
        return this;
    }

    public synchronized StaticRoutingDecisionProvider remove(@NonNull String signature) {
        if (this.whitelistSignaturesFromUserControlledList.remove(signature)) {
            LOGGER.log(Level.INFO, "Signature [{0}] removed from the whitelist", signature);
            this.save();
            this.resetMetaClassCache();
        } else {
            LOGGER.log(Level.INFO, "Signature [{0}] was not present in the whitelist", signature);
        }
        return this;
    }

    public synchronized StaticRoutingDecisionProvider removeBlacklistSignature(@NonNull String signature) {
        if (this.blacklistSignaturesFromUserControlledList.remove(signature)) {
            LOGGER.log(Level.INFO, "Signature [{0}] removed from the blacklist", signature);
            this.save();
            this.resetMetaClassCache();
        } else {
            LOGGER.log(Level.INFO, "Signature [{0}] was not present in the blacklist", signature);
        }
        return this;
    }

    @Override
    public synchronized void save() {
        if (BulkChange.contains(this)) {
            return;
        }
        File file = this.getConfigFile();
        try {
            ArrayList<String> allSignatures = new ArrayList<String>(this.whitelistSignaturesFromUserControlledList);
            this.blacklistSignaturesFromUserControlledList.stream().map(signature -> "!" + signature).forEach(allSignatures::add);
            FileUtils.writeLines((File)file, allSignatures);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + file.getAbsolutePath(), e);
        }
    }

    private synchronized void reloadFromUserControlledList() {
        File file = this.getConfigFile();
        if (!file.exists()) {
            if (this.whitelistSignaturesFromUserControlledList != null && this.whitelistSignaturesFromUserControlledList.isEmpty() || this.blacklistSignaturesFromUserControlledList != null && this.blacklistSignaturesFromUserControlledList.isEmpty()) {
                LOGGER.log(Level.INFO, "No whitelist source file found at " + file + " so resetting user-controlled whitelist");
            }
            this.whitelistSignaturesFromUserControlledList = new HashSet<String>();
            this.blacklistSignaturesFromUserControlledList = new HashSet<String>();
            return;
        }
        LOGGER.log(Level.INFO, "Whitelist source file found at " + file);
        try {
            this.whitelistSignaturesFromUserControlledList = new HashSet<String>();
            this.blacklistSignaturesFromUserControlledList = new HashSet<String>();
            this.parseFileIntoList(FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8), this.whitelistSignaturesFromUserControlledList, this.blacklistSignaturesFromUserControlledList);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load " + file.getAbsolutePath(), e);
        }
    }

    private File getConfigFile() {
        return new File(WHITELIST_PATH == null ? new File(Jenkins.get().getRootDir(), "stapler-whitelist.txt").toString() : WHITELIST_PATH);
    }

    private void parseFileIntoList(List<String> lines, Set<String> whitelist, Set<String> blacklist) {
        lines.stream().filter(line -> !line.matches("#.*|\\s*")).forEach(line -> {
            if (line.startsWith("!")) {
                String withoutExclamation = line.substring(1);
                if (!withoutExclamation.isEmpty()) {
                    blacklist.add(withoutExclamation);
                }
            } else {
                whitelist.add((String)line);
            }
        });
    }
}

