/*
 * Decompiled with CFR 0.152.
 */
package jenkins.telemetry;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.ProxyConfiguration;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import hudson.model.UsageStatistics;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.telemetry.Correlator;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class Telemetry
implements ExtensionPoint {
    @Restricted(value={NoExternalUse.class})
    @VisibleForTesting
    static String ENDPOINT = SystemProperties.getString(Telemetry.class.getName() + ".endpoint", "https://uplink.jenkins.io/events");
    private static final Logger LOGGER = Logger.getLogger(Telemetry.class.getName());

    @NonNull
    public String getId() {
        return this.getClass().getName();
    }

    @NonNull
    public abstract String getDisplayName();

    @NonNull
    public abstract LocalDate getStart();

    @NonNull
    public abstract LocalDate getEnd();

    @CheckForNull
    public abstract JSONObject createContent();

    public static ExtensionList<Telemetry> all() {
        return ExtensionList.lookup(Telemetry.class);
    }

    public static boolean isDisabled() {
        if (UsageStatistics.DISABLED) {
            return true;
        }
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        return jenkins == null || !jenkins.isUsageStatisticsCollected();
    }

    public boolean isActivePeriod() {
        LocalDate now = LocalDate.now();
        return now.isAfter(this.getStart()) && now.isBefore(this.getEnd());
    }

    @Extension
    public static class TelemetryReporter
    extends AsyncPeriodicWork {
        public TelemetryReporter() {
            super("telemetry collection");
        }

        @Override
        public long getRecurrencePeriod() {
            return TimeUnit.HOURS.toMillis(24L);
        }

        @Override
        protected void execute(TaskListener listener) throws IOException, InterruptedException {
            if (Telemetry.isDisabled()) {
                LOGGER.info("Collection of anonymous usage statistics is disabled, skipping telemetry collection and submission");
                return;
            }
            Telemetry.all().forEach(telemetry -> {
                if (telemetry.getStart().isAfter(LocalDate.now())) {
                    LOGGER.config("Skipping telemetry for '" + telemetry.getId() + "' as it is configured to start later");
                    return;
                }
                if (telemetry.getEnd().isBefore(LocalDate.now())) {
                    LOGGER.config("Skipping telemetry for '" + telemetry.getId() + "' as it is configured to end in the past");
                    return;
                }
                JSONObject data = new JSONObject();
                try {
                    data = telemetry.createContent();
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to build telemetry content for: '" + telemetry.getId() + "'", e);
                }
                if (data == null) {
                    LOGGER.log(Level.CONFIG, "Skipping telemetry for '" + telemetry.getId() + "' as it has no data");
                    return;
                }
                JSONObject wrappedData = new JSONObject();
                wrappedData.put("type", (Object)telemetry.getId());
                wrappedData.put("payload", (Object)data);
                String correlationId = ExtensionList.lookupSingleton(Correlator.class).getCorrelationId();
                wrappedData.put("correlator", (Object)DigestUtils.sha256Hex((String)(correlationId + telemetry.getId())));
                try {
                    URL url = new URL(ENDPOINT);
                    URLConnection conn = ProxyConfiguration.open(url);
                    if (!(conn instanceof HttpURLConnection)) {
                        LOGGER.config("URL did not result in an HttpURLConnection: " + ENDPOINT);
                        return;
                    }
                    HttpURLConnection http = (HttpURLConnection)conn;
                    http.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                    http.setDoOutput(true);
                    String body = wrappedData.toString();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Submitting JSON: " + body);
                    }
                    try (OutputStream out = http.getOutputStream();
                         OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
                        writer.append(body);
                    }
                    LOGGER.config("Telemetry submission received response '" + http.getResponseCode() + " " + http.getResponseMessage() + "' for: " + telemetry.getId());
                }
                catch (MalformedURLException e) {
                    LOGGER.config("Malformed endpoint URL: " + ENDPOINT + " for telemetry: " + telemetry.getId());
                }
                catch (IOException e) {
                    LOGGER.log(Level.CONFIG, "Failed to submit telemetry: " + telemetry.getId() + " to: " + ENDPOINT, e);
                }
            });
        }
    }
}

