/*
 * Decompiled with CFR 0.152.
 */
package jenkins.telemetry.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.telemetry.Telemetry;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class UserLanguages
extends Telemetry {
    private static final Map<String, AtomicLong> requestsByLanguage = new ConcurrentSkipListMap<String, AtomicLong>();
    private static Logger LOGGER = Logger.getLogger(UserLanguages.class.getName());

    @Override
    @NonNull
    public String getId() {
        return UserLanguages.class.getName();
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Browser languages";
    }

    @Override
    @NonNull
    public LocalDate getStart() {
        return LocalDate.of(2018, 10, 1);
    }

    @Override
    @NonNull
    public LocalDate getEnd() {
        return LocalDate.of(2019, 1, 1);
    }

    @Override
    public JSONObject createContent() {
        if (requestsByLanguage.size() == 0) {
            return null;
        }
        TreeMap<String, AtomicLong> currentRequests = new TreeMap<String, AtomicLong>(requestsByLanguage);
        requestsByLanguage.clear();
        JSONObject payload = new JSONObject();
        for (Map.Entry entry : currentRequests.entrySet()) {
            payload.put((String)entry.getKey(), (Object)((AtomicLong)entry.getValue()).longValue());
        }
        return payload;
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void setUpFilter() {
        AcceptLanguageFilter filter = new AcceptLanguageFilter();
        if (!PluginServletFilter.hasFilter(filter)) {
            try {
                PluginServletFilter.addFilter(filter);
            }
            catch (ServletException ex) {
                LOGGER.log(Level.WARNING, "Failed to set up languages servlet filter", ex);
            }
        }
    }

    public static final class AcceptLanguageFilter
    implements Filter {
        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpServletRequest httpServletRequest;
            String language;
            if (request instanceof HttpServletRequest && !Telemetry.isDisabled() && (language = (httpServletRequest = (HttpServletRequest)request).getHeader("Accept-Language")) != null) {
                if (!requestsByLanguage.containsKey(language)) {
                    requestsByLanguage.put(language, new AtomicLong(0L));
                }
                ((AtomicLong)requestsByLanguage.get(language)).incrementAndGet();
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == AcceptLanguageFilter.class;
        }

        public int hashCode() {
            return 42;
        }
    }
}

