/*
 * Decompiled with CFR 0.152.
 */
package jenkins.telemetry.impl.java11;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import jenkins.telemetry.impl.java11.MissingClassEvent;
import jenkins.telemetry.impl.java11.MissingClassTelemetry;

public class MissingClassEvents {
    @VisibleForTesting
    static int MAX_EVENTS_PER_SEND = 100;
    private ConcurrentHashMap<List<StackTraceElement>, MissingClassEvent> events = new ConcurrentHashMap(MAX_EVENTS_PER_SEND);
    private ConcurrentHashMap<String, MissingClassEvent> eventsOnThisExecution = new ConcurrentHashMap(MAX_EVENTS_PER_SEND);

    public long put(String name, @NonNull Throwable t) {
        AtomicLong occurrences = new AtomicLong();
        List<StackTraceElement> key = Collections.unmodifiableList(Arrays.asList(t.getStackTrace()));
        MissingClassEvent newEvent = new MissingClassEvent(name, t);
        this.events.compute(key, (stackTraceElements, missingClassEvent) -> {
            if (missingClassEvent == null) {
                if (this.events.size() < MAX_EVENTS_PER_SEND) {
                    occurrences.set(1L);
                    return newEvent;
                }
                return null;
            }
            occurrences.set(missingClassEvent.getOccurrences());
            missingClassEvent.setOccurrences(occurrences.incrementAndGet());
            missingClassEvent.setTime(MissingClassTelemetry.clientDateString());
            return missingClassEvent;
        });
        this.eventsOnThisExecution.putIfAbsent(name, newEvent);
        return occurrences.get();
    }

    @VisibleForTesting
    @NonNull
    synchronized ConcurrentHashMap<List<StackTraceElement>, MissingClassEvent> getEventsAndClean() {
        ConcurrentHashMap<List<StackTraceElement>, MissingClassEvent> currentEvents = this.events;
        this.events = new ConcurrentHashMap(MAX_EVENTS_PER_SEND);
        return currentEvents;
    }

    public boolean alreadyRegistered(@NonNull String className) {
        return this.eventsOnThisExecution.containsKey(className);
    }

    void clearEventsOnThisExecution() {
        this.eventsOnThisExecution.clear();
    }

    public String toString() {
        return "MissingClassEvents{events=" + this.events + '}';
    }
}

