/*
 * Decompiled with CFR 0.152.
 */
package jenkins.websocket;

import hudson.Extension;
import hudson.ExtensionList;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.websocket.WebSocketSession;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;

@Restricted(value={Beta.class})
@Extension
public class WebSockets {
    private static final Logger LOGGER = Logger.getLogger(WebSockets.class.getName());
    private static final String ATTR_SESSION = WebSockets.class.getName() + ".session";
    private static ClassLoader cl;
    private static Class<?> webSocketServletFactoryClass;
    private Object factory;

    public static HttpResponse upgrade(WebSocketSession session) {
        return (req, rsp, node) -> {
            try {
                Object factory = ExtensionList.lookupSingleton(WebSockets.class).init();
                if (!((Boolean)webSocketServletFactoryClass.getMethod("isUpgradeRequest", HttpServletRequest.class, HttpServletResponse.class).invoke(factory, req, rsp)).booleanValue()) {
                    throw HttpResponses.errorWithoutStack((int)400, (String)"only WS connections accepted here");
                }
                req.setAttribute(ATTR_SESSION, (Object)session);
                if (!((Boolean)webSocketServletFactoryClass.getMethod("acceptWebSocket", HttpServletRequest.class, HttpServletResponse.class).invoke(factory, req, rsp)).booleanValue()) {
                    throw HttpResponses.errorWithoutStack((int)400, (String)"did not manage to upgrade");
                }
            }
            catch (HttpResponses.HttpResponseException x) {
                throw x;
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, null, x);
                throw HttpResponses.error((Throwable)x);
            }
        };
    }

    private static synchronized void staticInit() throws Exception {
        if (webSocketServletFactoryClass == null) {
            cl = ServletContext.class.getClassLoader();
            webSocketServletFactoryClass = cl.loadClass("org.eclipse.jetty.websocket.servlet.WebSocketServletFactory");
        }
    }

    public static boolean isSupported() {
        try {
            WebSockets.staticInit();
            return true;
        }
        catch (Exception x) {
            LOGGER.log(Level.FINE, null, x);
            return false;
        }
    }

    private synchronized Object init() throws Exception {
        if (this.factory == null) {
            WebSockets.staticInit();
            Class<?> webSocketPolicyClass = cl.loadClass("org.eclipse.jetty.websocket.api.WebSocketPolicy");
            this.factory = cl.loadClass("org.eclipse.jetty.websocket.servlet.WebSocketServletFactory$Loader").getMethod("load", ServletContext.class, webSocketPolicyClass).invoke(null, Stapler.getCurrent().getServletContext(), webSocketPolicyClass.getMethod("newServerPolicy", new Class[0]).invoke(null, new Object[0]));
            webSocketServletFactoryClass.getMethod("start", new Class[0]).invoke(this.factory, new Object[0]);
            Class<?> webSocketCreatorClass = cl.loadClass("org.eclipse.jetty.websocket.servlet.WebSocketCreator");
            webSocketServletFactoryClass.getMethod("setCreator", webSocketCreatorClass).invoke(this.factory, Proxy.newProxyInstance(cl, new Class[]{webSocketCreatorClass}, this::createWebSocket));
        }
        return this.factory;
    }

    private Object createWebSocket(Object proxy, Method method, Object[] args) throws Exception {
        Object servletUpgradeRequest = args[0];
        WebSocketSession session = (WebSocketSession)servletUpgradeRequest.getClass().getMethod("getServletAttribute", String.class).invoke(servletUpgradeRequest, ATTR_SESSION);
        return Proxy.newProxyInstance(cl, new Class[]{cl.loadClass("org.eclipse.jetty.websocket.api.WebSocketListener")}, session::onWebSocketSomething);
    }
}

