/*
 * Decompiled with CFR 0.152.
 */
package jenkins.widgets;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Queue;
import hudson.model.Run;

public class HistoryPageEntry<T> {
    private final T entry;

    public HistoryPageEntry(T entry) {
        this.entry = entry;
    }

    public T getEntry() {
        return this.entry;
    }

    public long getEntryId() {
        return HistoryPageEntry.getEntryId(this.entry);
    }

    protected static long getEntryId(@NonNull Object entry) {
        if (entry instanceof Queue.Item) {
            return ((Queue.Item)entry).getId();
        }
        if (entry instanceof Run) {
            Run run = (Run)entry;
            return Long.MIN_VALUE + (long)run.getNumber();
        }
        if (entry instanceof Number) {
            return Long.MIN_VALUE + ((Number)entry).longValue();
        }
        return -1L;
    }
}

