/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;

@Extension
public class GroovyCommand
extends CLICommand {
    @Argument(metaVar="SCRIPT", usage="Script to be executed. Only '=' (to represent stdin) is supported.")
    public String script;
    @Argument(metaVar="ARGUMENTS", index=1, usage="Command line arguments to pass into script.")
    public List<String> remaining = new ArrayList<String>();

    @Override
    public String getShortDescription() {
        return Messages.GroovyCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Binding binding = new Binding();
        binding.setProperty("out", (Object)new PrintWriter(this.stdout, true));
        binding.setProperty("stdin", (Object)this.stdin);
        binding.setProperty("stdout", (Object)this.stdout);
        binding.setProperty("stderr", (Object)this.stderr);
        GroovyShell groovy = new GroovyShell(Jenkins.get().getPluginManager().uberClassLoader, binding);
        groovy.run(this.loadScript(), "RemoteClass", this.remaining.toArray(new String[0]));
        return 0;
    }

    private String loadScript() throws CmdLineException, IOException, InterruptedException {
        if (this.script == null) {
            throw new CmdLineException(null, "No script is specified");
        }
        if (this.script.equals("=")) {
            return IOUtils.toString((InputStream)this.stdin);
        }
        this.checkChannel();
        return null;
    }
}

