/*
 * Decompiled with CFR 0.152.
 */
package hudson.init.impl;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.init.Initializer;
import java.io.EOFException;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.telemetry.impl.java11.MissingClassTelemetry;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.compression.CompressionFilter;

public class InstallUncaughtExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(InstallUncaughtExceptionHandler.class.getName());

    @Initializer
    public static void init(Jenkins j) throws IOException {
        CompressionFilter.setUncaughtExceptionHandler((ServletContext)j.servletContext, (e, context, req, rsp) -> InstallUncaughtExceptionHandler.handleException(j, e, req, rsp, 500));
        try {
            Thread.setDefaultUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
            LOGGER.log(Level.FINE, "Successfully installed a global UncaughtExceptionHandler.");
        }
        catch (SecurityException ex) {
            LOGGER.log(Level.SEVERE, "Failed to set the default UncaughtExceptionHandler.  If any threads die due to unhandled coding errors then there will be no logging of this information.  The lack of this diagnostic information will make it harder to track down issues which will reduce the supportability of Jenkins.  It is highly recommended that you consult the documentation that comes with you servlet container on how to allow the `setDefaultUncaughtExceptionHandler` permission and enable it.", ex);
        }
    }

    private static void handleException(Jenkins j, Throwable e, HttpServletRequest req, HttpServletResponse rsp, int code) throws IOException, ServletException {
        block3: {
            if (rsp.isCommitted()) {
                LOGGER.log(InstallUncaughtExceptionHandler.isEOFException(e) ? Level.FINE : Level.WARNING, null, e);
                return;
            }
            String id = UUID.randomUUID().toString();
            LOGGER.log(InstallUncaughtExceptionHandler.isEOFException(e) ? Level.FINE : Level.WARNING, "Caught unhandled exception with ID " + id, e);
            req.setAttribute("jenkins.exception.id", (Object)id);
            req.setAttribute("javax.servlet.error.exception", (Object)e);
            rsp.setStatus(code);
            try {
                MissingClassTelemetry.reportExceptionInside(e);
                WebApp.get((ServletContext)j.servletContext).getSomeStapler().invoke(req, rsp, (Object)j, "/oops");
            }
            catch (IOException | ServletException x) {
                if (Stapler.isSocketException((Throwable)x)) break block3;
                throw x;
            }
        }
    }

    private static boolean isEOFException(Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof EOFException) {
            return true;
        }
        return InstallUncaughtExceptionHandler.isEOFException(e.getCause());
    }

    private InstallUncaughtExceptionHandler() {
    }

    private static class DefaultUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private DefaultUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable ex) {
            LOGGER.log(Level.SEVERE, "A thread (" + t.getName() + '/' + t.getId() + ") died unexpectedly due to an uncaught exception, this may leave your Jenkins in a bad way and is usually indicative of a bug in the code.", ex);
            MissingClassTelemetry.reportExceptionInside(ex);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class ErrorCustomizer
    implements HttpResponses.ErrorCustomizer {
        @CheckForNull
        public HttpResponses.HttpResponseException handleError(final int code, final Throwable cause) {
            if (Jenkins.getInstanceOrNull() == null) {
                return null;
            }
            return new HttpResponses.HttpResponseException(cause){

                public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
                    InstallUncaughtExceptionHandler.handleException(Jenkins.get(), cause, (HttpServletRequest)req, (HttpServletResponse)rsp, code);
                }
            };
        }
    }
}

