/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.model.Messages;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.StringParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.model.TextParameterValue;
import java.util.Objects;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class TextParameterDefinition
extends StringParameterDefinition {
    @DataBoundConstructor
    public TextParameterDefinition(String name) {
        super(name);
    }

    public TextParameterDefinition(String name, String defaultValue, String description) {
        this(name);
        this.setDefaultValue(defaultValue);
        this.setDescription(description);
    }

    @Override
    public StringParameterValue getDefaultParameterValue() {
        return new TextParameterValue(this.getName(), this.getDefaultValue(), this.getDescription());
    }

    @Override
    public ParameterValue createValue(StaplerRequest req, JSONObject jo) {
        TextParameterValue value = (TextParameterValue)req.bindJSON(TextParameterValue.class, jo);
        value.setDescription(this.getDescription());
        return value;
    }

    @Override
    public ParameterValue createValue(String value) {
        return new TextParameterValue(this.getName(), value, this.getDescription());
    }

    @Override
    public int hashCode() {
        if (TextParameterDefinition.class != this.getClass()) {
            return super.hashCode();
        }
        return Objects.hash(this.getName(), this.getDescription(), this.getDefaultValue(), this.isTrim());
    }

    @Override
    public boolean equals(Object obj) {
        if (TextParameterDefinition.class != this.getClass()) {
            return super.equals(obj);
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextParameterDefinition other = (TextParameterDefinition)obj;
        if (!Objects.equals(this.getName(), other.getName())) {
            return false;
        }
        if (!Objects.equals(this.getDescription(), other.getDescription())) {
            return false;
        }
        if (!Objects.equals(this.getDefaultValue(), other.getDefaultValue())) {
            return false;
        }
        return this.isTrim() == other.isTrim();
    }

    @Extension
    @Symbol(value={"text", "textParam"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.TextParameterDefinition_DisplayName();
        }
    }
}

