/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.User;
import hudson.model.View;
import hudson.model.ViewDescriptor;
import hudson.model.ViewGroup;
import hudson.remoting.Callable;
import hudson.security.ACLContext;
import hudson.security.AccessDeniedException3;
import hudson.security.Messages;
import hudson.security.Permission;
import java.util.LinkedHashSet;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.security.NonSerializableSecurityContext;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.context.SecurityContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class ACL {
    public static final Sid EVERYONE = new Sid(){

        public String toString() {
            return "EVERYONE";
        }
    };
    @Restricted(value={NoExternalUse.class})
    public static final String ANONYMOUS_USERNAME = "anonymous";
    public static final Sid ANONYMOUS = new PrincipalSid("anonymous");
    protected static final Sid[] AUTOMATIC_SIDS = new Sid[]{EVERYONE, ANONYMOUS};
    @Restricted(value={NoExternalUse.class})
    public static final String SYSTEM_USERNAME = "SYSTEM";
    public static final org.springframework.security.core.Authentication SYSTEM2 = new UsernamePasswordAuthenticationToken((Object)"SYSTEM", (Object)"SYSTEM");
    @Deprecated
    public static final Authentication SYSTEM = new org.acegisecurity.providers.UsernamePasswordAuthenticationToken((UsernamePasswordAuthenticationToken)SYSTEM2);

    public final void checkPermission(@NonNull Permission p) {
        org.springframework.security.core.Authentication a = Jenkins.getAuthentication2();
        if (a.equals(SYSTEM2)) {
            return;
        }
        if (!this.hasPermission2(a, p)) {
            while (!p.enabled && p.impliedBy != null) {
                p = p.impliedBy;
            }
            throw new AccessDeniedException3(a, p);
        }
    }

    public final void checkAnyPermission(Permission ... permissions) {
        if (permissions.length == 0) {
            throw new IllegalArgumentException("At least one permission must be provided");
        }
        boolean failed = !this.hasAnyPermission(permissions);
        org.springframework.security.core.Authentication authentication = Jenkins.getAuthentication2();
        if (failed) {
            LinkedHashSet<Permission> enabledPermissions = new LinkedHashSet<Permission>();
            for (Permission p2 : permissions) {
                while (!p2.enabled && p2.impliedBy != null) {
                    p2 = p2.impliedBy;
                }
                enabledPermissions.add(p2);
            }
            String permissionsDisplayName = enabledPermissions.stream().map(p -> p.group.title + "/" + p.name).collect(Collectors.joining(", "));
            String errorMessage = enabledPermissions.size() == 1 ? Messages.AccessDeniedException2_MissingPermission(authentication.getName(), permissionsDisplayName) : Messages.AccessDeniedException_MissingPermissions(authentication.getName(), permissionsDisplayName);
            throw new AccessDeniedException(errorMessage);
        }
    }

    public final boolean hasPermission(@NonNull Permission p) {
        org.springframework.security.core.Authentication a = Jenkins.getAuthentication2();
        if (a.equals(SYSTEM2)) {
            return true;
        }
        return this.hasPermission2(a, p);
    }

    public final boolean hasAnyPermission(Permission ... permissions) {
        if (permissions.length == 0) {
            throw new IllegalArgumentException("At least one permission must be provided");
        }
        org.springframework.security.core.Authentication a = Jenkins.getAuthentication2();
        if (a.equals(SYSTEM2)) {
            return true;
        }
        for (Permission permission : permissions) {
            if (!this.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission2(@NonNull org.springframework.security.core.Authentication a, @NonNull Permission permission) {
        if (Util.isOverridden(ACL.class, this.getClass(), "hasPermission", Authentication.class, Permission.class)) {
            return this.hasPermission(Authentication.fromSpring(a), permission);
        }
        throw new AbstractMethodError("implement hasPermission2");
    }

    @Deprecated
    public boolean hasPermission(@NonNull Authentication a, @NonNull Permission permission) {
        return this.hasPermission2(a.toSpring(), permission);
    }

    public static ACL lambda2(final BiFunction<org.springframework.security.core.Authentication, Permission, Boolean> impl) {
        return new ACL(){

            @Override
            public boolean hasPermission2(org.springframework.security.core.Authentication a, Permission permission) {
                return (Boolean)impl.apply(a, permission);
            }
        };
    }

    @Deprecated
    public static ACL lambda(final BiFunction<Authentication, Permission, Boolean> impl) {
        return new ACL(){

            @Override
            public boolean hasPermission(Authentication a, Permission permission) {
                return (Boolean)impl.apply(a, permission);
            }
        };
    }

    public final void checkCreatePermission(@NonNull ItemGroup c, @NonNull TopLevelItemDescriptor d) {
        org.springframework.security.core.Authentication a = Jenkins.getAuthentication2();
        if (a.equals(SYSTEM2)) {
            return;
        }
        if (!this.hasCreatePermission2(a, c, d)) {
            throw new AccessDeniedException(Messages.AccessDeniedException2_MissingPermission(a.getName(), Item.CREATE.group.title + "/" + Item.CREATE.name + Item.CREATE + "/" + d.getDisplayName()));
        }
    }

    public boolean hasCreatePermission2(@NonNull org.springframework.security.core.Authentication a, @NonNull ItemGroup c, @NonNull TopLevelItemDescriptor d) {
        if (Util.isOverridden(ACL.class, this.getClass(), "hasCreatePermission", Authentication.class, ItemGroup.class, TopLevelItemDescriptor.class)) {
            return this.hasCreatePermission(Authentication.fromSpring(a), c, d);
        }
        return true;
    }

    @Deprecated
    public boolean hasCreatePermission(@NonNull Authentication a, @NonNull ItemGroup c, @NonNull TopLevelItemDescriptor d) {
        return this.hasCreatePermission2(a.toSpring(), c, d);
    }

    public final void checkCreatePermission(@NonNull ViewGroup c, @NonNull ViewDescriptor d) {
        org.springframework.security.core.Authentication a = Jenkins.getAuthentication2();
        if (a.equals(SYSTEM2)) {
            return;
        }
        if (!this.hasCreatePermission2(a, c, d)) {
            throw new AccessDeniedException(Messages.AccessDeniedException2_MissingPermission(a.getName(), View.CREATE.group.title + "/" + View.CREATE.name + View.CREATE + "/" + d.getDisplayName()));
        }
    }

    public boolean hasCreatePermission2(@NonNull org.springframework.security.core.Authentication a, @NonNull ViewGroup c, @NonNull ViewDescriptor d) {
        if (Util.isOverridden(ACL.class, this.getClass(), "hasCreatePermission", Authentication.class, ViewGroup.class, ViewDescriptor.class)) {
            return this.hasCreatePermission(Authentication.fromSpring(a), c, d);
        }
        return true;
    }

    @Deprecated
    public boolean hasCreatePermission(@NonNull Authentication a, @NonNull ViewGroup c, @NonNull ViewDescriptor d) {
        return this.hasCreatePermission2(a.toSpring(), c, d);
    }

    @Deprecated
    @NonNull
    public static org.springframework.security.core.context.SecurityContext impersonate2(@NonNull org.springframework.security.core.Authentication auth) {
        org.springframework.security.core.context.SecurityContext old = SecurityContextHolder.getContext();
        SecurityContextHolder.setContext((org.springframework.security.core.context.SecurityContext)new NonSerializableSecurityContext(auth));
        return old;
    }

    @Deprecated
    @NonNull
    public static SecurityContext impersonate(@NonNull Authentication auth) {
        return SecurityContext.fromSpring(ACL.impersonate2(auth.toSpring()));
    }

    @Deprecated
    public static void impersonate2(@NonNull org.springframework.security.core.Authentication auth, @NonNull Runnable body) {
        org.springframework.security.core.context.SecurityContext old = ACL.impersonate2(auth);
        try {
            body.run();
        }
        finally {
            SecurityContextHolder.setContext((org.springframework.security.core.context.SecurityContext)old);
        }
    }

    @Deprecated
    public static void impersonate(@NonNull Authentication auth, @NonNull Runnable body) {
        ACL.impersonate2(auth.toSpring(), body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static <V, T extends Exception> V impersonate2(org.springframework.security.core.Authentication auth, Callable<V, T> body) throws T {
        org.springframework.security.core.context.SecurityContext old = ACL.impersonate2(auth);
        try {
            Object object = body.call();
            return (V)object;
        }
        finally {
            SecurityContextHolder.setContext((org.springframework.security.core.context.SecurityContext)old);
        }
    }

    @Deprecated
    public static <V, T extends Exception> V impersonate(Authentication auth, Callable<V, T> body) throws T {
        return ACL.impersonate2(auth.toSpring(), body);
    }

    @NonNull
    public static ACLContext as2(@NonNull org.springframework.security.core.Authentication auth) {
        ACLContext context = new ACLContext(SecurityContextHolder.getContext());
        SecurityContextHolder.setContext((org.springframework.security.core.context.SecurityContext)new NonSerializableSecurityContext(auth));
        return context;
    }

    @Deprecated
    @NonNull
    public static ACLContext as(@NonNull Authentication auth) {
        return ACL.as2(auth.toSpring());
    }

    @NonNull
    public static ACLContext as(@CheckForNull User user) {
        return ACL.as2(user == null ? Jenkins.ANONYMOUS2 : user.impersonate2());
    }

    public static boolean isAnonymous2(@NonNull org.springframework.security.core.Authentication authentication) {
        return authentication instanceof AnonymousAuthenticationToken;
    }

    @Deprecated
    public static boolean isAnonymous(@NonNull Authentication authentication) {
        return ACL.isAnonymous2(authentication.toSpring());
    }
}

