/*
 * Decompiled with CFR 0.152.
 */
package hudson.security.csrf;

import hudson.security.csrf.CrumbExclusion;
import hudson.security.csrf.CrumbIssuer;
import hudson.security.csrf.CrumbIssuerDescriptor;
import hudson.util.MultipartFormDataParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.ForwardToView;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.authentication.AnonymousAuthenticationToken;

public class CrumbFilter
implements Filter {
    static boolean UNPROCESSED_PATHINFO = SystemProperties.getBoolean(CrumbFilter.class.getName() + ".UNPROCESSED_PATHINFO");
    private static final Logger LOGGER = Logger.getLogger(CrumbFilter.class.getName());

    public CrumbIssuer getCrumbIssuer() {
        Jenkins h = Jenkins.getInstanceOrNull();
        if (h == null) {
            return null;
        }
        return h.getCrumbIssuer();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        CrumbIssuer crumbIssuer = this.getCrumbIssuer();
        if (crumbIssuer == null || !(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if ("POST".equals(httpRequest.getMethod())) {
            Level level;
            Object wrappedRequest = UNPROCESSED_PATHINFO ? httpRequest : new Security1774ServletRequest(httpRequest);
            for (CrumbExclusion e : CrumbExclusion.all()) {
                if (!e.process((HttpServletRequest)wrappedRequest, httpResponse, chain)) continue;
                return;
            }
            String crumbFieldName = ((CrumbIssuerDescriptor)crumbIssuer.getDescriptor()).getCrumbRequestField();
            String crumbSalt = ((CrumbIssuerDescriptor)crumbIssuer.getDescriptor()).getCrumbSalt();
            boolean valid = false;
            String crumb = this.extractCrumbFromRequest(httpRequest, crumbFieldName);
            if (crumb == null) {
                this.extractCrumbFromRequest(httpRequest, ".crumb");
            }
            Level level2 = level = Jenkins.getAuthentication2() instanceof AnonymousAuthenticationToken ? Level.FINE : Level.WARNING;
            if (crumb != null) {
                if (crumbIssuer.validateCrumb((ServletRequest)httpRequest, crumbSalt, crumb)) {
                    valid = true;
                } else {
                    LOGGER.log(level, "Found invalid crumb {0}. If you are calling this URL with a script, please use the API Token instead. More information: https://www.jenkins.io/redirect/crumb-cannot-be-used-for-script", crumb);
                }
            }
            if (valid) {
                chain.doFilter(request, response);
            } else {
                LOGGER.log(level, "No valid crumb was included in request for {0} by {1}. Returning {2}.", new Object[]{httpRequest.getRequestURI(), Jenkins.getAuthentication2().getName(), 403});
                httpResponse.sendError(403, "No valid crumb was included in the request");
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private String extractCrumbFromRequest(HttpServletRequest httpRequest, String crumbFieldName) {
        String crumb = httpRequest.getHeader(crumbFieldName);
        if (crumb == null) {
            Enumeration paramNames = httpRequest.getParameterNames();
            while (paramNames.hasMoreElements()) {
                String paramName = (String)paramNames.nextElement();
                if (!crumbFieldName.equals(paramName)) continue;
                crumb = httpRequest.getParameter(paramName);
                break;
            }
        }
        return crumb;
    }

    protected static boolean isMultipart(HttpServletRequest request) {
        if (request == null) {
            return false;
        }
        return MultipartFormDataParser.isMultiPartForm(request.getContentType());
    }

    public void destroy() {
    }

    private static class Security1774ServletRequest
    extends HttpServletRequestWrapper {
        Security1774ServletRequest(HttpServletRequest request) {
            super(request);
        }

        public String getPathInfo() {
            return Security1774ServletRequest.canonicalPath(this.getRequestURI().substring(this.getContextPath().length()));
        }

        private static String canonicalPath(String path) {
            ArrayList<String> r = new ArrayList<String>(Arrays.asList(path.split("/+")));
            int i = 0;
            while (i < r.size()) {
                if (((String)r.get(i)).length() == 0 || ((String)r.get(i)).equals(".")) {
                    r.remove(i);
                    continue;
                }
                if (((String)r.get(i)).equals("..")) {
                    r.remove(i);
                    if (i <= 0) continue;
                    r.remove(i - 1);
                    --i;
                    continue;
                }
                ++i;
            }
            StringBuilder buf = new StringBuilder();
            if (path.startsWith("/")) {
                buf.append('/');
            }
            boolean first = true;
            for (String token : r) {
                if (!first) {
                    buf.append('/');
                } else {
                    first = false;
                }
                buf.append(token);
            }
            if (path.endsWith("/") && (buf.length() == 0 || buf.charAt(buf.length() - 1) != '/')) {
                buf.append('/');
            }
            return buf.toString();
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class ErrorCustomizer
    implements RequirePOST.ErrorCustomizer {
        public ForwardToView getForwardView() {
            return new ForwardToView(CrumbFilter.class, "retry");
        }
    }
}

