/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.Messages;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import jenkins.model.Jenkins;
import jenkins.slaves.RemotingWorkDirSettings;
import jenkins.util.SystemProperties;
import jenkins.util.java.JavaUtils;
import jenkins.websocket.WebSockets;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class JNLPLauncher
extends ComputerLauncher {
    @CheckForNull
    public final String tunnel;
    @CheckForNull
    public final String vmargs;
    @NonNull
    private RemotingWorkDirSettings workDirSettings = RemotingWorkDirSettings.getEnabledDefaults();
    private boolean webSocket;
    @Restricted(value={NoExternalUse.class})
    @NonNull
    public static final String CUSTOM_INBOUND_URL_PROPERTY = "jenkins.agent.inboundUrl";
    @Deprecated
    public static Descriptor<ComputerLauncher> DESCRIPTOR;

    @Deprecated
    public JNLPLauncher(@CheckForNull String tunnel, @CheckForNull String vmargs, @CheckForNull RemotingWorkDirSettings workDirSettings) {
        this(tunnel, vmargs);
        if (workDirSettings != null) {
            this.setWorkDirSettings(workDirSettings);
        }
    }

    @DataBoundConstructor
    public JNLPLauncher(@CheckForNull String tunnel, @CheckForNull String vmargs) {
        this.tunnel = Util.fixEmptyAndTrim(tunnel);
        this.vmargs = Util.fixEmptyAndTrim(vmargs);
    }

    @Deprecated
    public JNLPLauncher() {
        this(false);
    }

    public JNLPLauncher(boolean enableWorkDir) {
        this(null, null, enableWorkDir ? RemotingWorkDirSettings.getEnabledDefaults() : RemotingWorkDirSettings.getDisabledDefaults());
    }

    protected Object readResolve() {
        if (this.workDirSettings == null) {
            this.workDirSettings = RemotingWorkDirSettings.getDisabledDefaults();
        }
        return this;
    }

    @NonNull
    public RemotingWorkDirSettings getWorkDirSettings() {
        return this.workDirSettings;
    }

    @DataBoundSetter
    public final void setWorkDirSettings(@NonNull RemotingWorkDirSettings workDirSettings) {
        this.workDirSettings = workDirSettings;
    }

    @Override
    public boolean isLaunchSupported() {
        return false;
    }

    public boolean isWebSocket() {
        return this.webSocket;
    }

    @DataBoundSetter
    public void setWebSocket(boolean webSocket) {
        this.webSocket = webSocket;
    }

    @Override
    public void launch(SlaveComputer computer, TaskListener listener) {
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public String getWorkDirOptions(@NonNull Computer computer) {
        if (!(computer instanceof SlaveComputer)) {
            return "";
        }
        return this.workDirSettings.toCommandLineString((SlaveComputer)computer);
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isJavaWebStartSupported() {
        return JavaUtils.isRunningWithJava8OrBelow();
    }

    @Restricted(value={NoExternalUse.class})
    public static String getInboundAgentUrl() {
        String url = SystemProperties.getString(CUSTOM_INBOUND_URL_PROPERTY);
        if (url == null || url.isEmpty()) {
            return Jenkins.get().getRootUrl();
        }
        return url;
    }

    @Extension
    @Symbol(value={"jnlp"})
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        public DescriptorImpl() {
            DESCRIPTOR = this;
        }

        @Override
        public String getDisplayName() {
            return Messages.JNLPLauncher_displayName();
        }

        public boolean isWorkDirSupported() {
            return DescriptorImpl.class.equals(this.getClass());
        }

        public FormValidation doCheckWebSocket(@QueryParameter boolean webSocket, @QueryParameter String tunnel) {
            if (webSocket) {
                if (!WebSockets.isSupported()) {
                    return FormValidation.error("WebSocket support is not enabled in this Jenkins installation");
                }
                if (Util.fixEmptyAndTrim(tunnel) != null) {
                    return FormValidation.error("Tunneling is not supported in WebSocket mode");
                }
            } else if (Jenkins.get().getTcpSlaveAgentListener() == null) {
                return FormValidation.error("Either WebSocket mode is selected, or the TCP port for inbound agents must be enabled");
            }
            return FormValidation.ok();
        }
    }
}

