/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import hudson.DescriptorExtensionList;
import hudson.Util;
import hudson.model.ComputerSet;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Node;
import hudson.slaves.Messages;
import hudson.util.DescriptorList;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public abstract class NodeDescriptor
extends Descriptor<Node> {
    @Deprecated
    public static final DescriptorList<Node> ALL = new DescriptorList<Node>(Node.class);

    protected NodeDescriptor(Class<? extends Node> clazz) {
        super(clazz);
    }

    protected NodeDescriptor() {
    }

    public boolean isInstantiable() {
        return true;
    }

    public final String newInstanceDetailPage() {
        return '/' + this.clazz.getName().replace('.', '/').replace('$', '/') + "/newInstanceDetail.jelly";
    }

    public void handleNewNodePage(ComputerSet computerSet, String name, StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        computerSet.checkName(name);
        req.setAttribute("descriptor", (Object)this);
        req.getView((Object)computerSet, "_new.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    @Override
    public String getConfigPage() {
        return this.getViewPage(this.clazz, "configure-entries.jelly");
    }

    public FormValidation doCheckName(@QueryParameter String value) {
        String name = Util.fixEmptyAndTrim(value);
        if (name == null) {
            return FormValidation.error(Messages.NodeDescriptor_CheckName_Mandatory());
        }
        try {
            Jenkins.checkGoodName(name);
        }
        catch (Failure f) {
            return FormValidation.error(f.getMessage());
        }
        return FormValidation.ok();
    }

    public static DescriptorExtensionList<Node, NodeDescriptor> all() {
        return Jenkins.get().getDescriptorList(Node.class);
    }

    public static List<NodeDescriptor> allInstantiable() {
        ArrayList<NodeDescriptor> r = new ArrayList<NodeDescriptor>();
        for (NodeDescriptor d : NodeDescriptor.all()) {
            if (!d.isInstantiable()) continue;
            r.add(d);
        }
        return r;
    }
}

