/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.DependencyGraph;
import hudson.model.Fingerprint;
import hudson.model.FingerprintMap;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Messages;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.PackedMap;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.DependencyDeclarer;
import jenkins.model.Jenkins;
import jenkins.model.RunAction2;
import jenkins.tasks.SimpleBuildStep;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.access.AccessDeniedException;

public class Fingerprinter
extends Recorder
implements Serializable,
DependencyDeclarer,
SimpleBuildStep {
    public static boolean enableFingerprintsInDependencyGraph = SystemProperties.getBoolean(Fingerprinter.class.getName() + ".enableFingerprintsInDependencyGraph");
    private final String targets;
    private String excludes = null;
    private Boolean defaultExcludes = true;
    private Boolean caseSensitive = true;
    @Deprecated
    Boolean recordBuildArtifacts;
    private static final Logger logger = Logger.getLogger(Fingerprinter.class.getName());
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public Fingerprinter(String targets) {
        this.targets = targets;
    }

    @DataBoundSetter
    public void setExcludes(String excludes) {
        this.excludes = Util.fixEmpty(excludes);
    }

    @DataBoundSetter
    public void setDefaultExcludes(boolean defaultExcludes) {
        this.defaultExcludes = defaultExcludes;
    }

    @DataBoundSetter
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Deprecated
    public Fingerprinter(String targets, boolean recordBuildArtifacts) {
        this(targets);
        this.recordBuildArtifacts = recordBuildArtifacts;
    }

    public String getTargets() {
        return this.targets;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public boolean getDefaultExcludes() {
        return this.defaultExcludes;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    private Object readResolve() {
        if (this.defaultExcludes == null) {
            this.defaultExcludes = true;
        }
        if (this.caseSensitive == null) {
            this.caseSensitive = true;
        }
        return this;
    }

    @Deprecated
    public boolean getRecordBuildArtifacts() {
        return this.recordBuildArtifacts != null && this.recordBuildArtifacts != false;
    }

    @Override
    public void perform(Run<?, ?> build, FilePath workspace, EnvVars environment, Launcher launcher, TaskListener listener) throws InterruptedException {
        try {
            FingerprintAction fingerprintAction;
            listener.getLogger().println(Messages.Fingerprinter_Recording());
            HashMap<String, String> record = new HashMap<String, String>();
            if (this.targets.length() != 0) {
                String expandedTargets = this.targets;
                if (build instanceof AbstractBuild) {
                    expandedTargets = environment.expand(expandedTargets);
                }
                this.record(build, workspace, listener, record, expandedTargets);
            }
            if ((fingerprintAction = build.getAction(FingerprintAction.class)) != null) {
                fingerprintAction.add(record);
            } else {
                build.addAction(new FingerprintAction(build, record));
            }
            if (enableFingerprintsInDependencyGraph) {
                Jenkins.get().rebuildDependencyGraphAsync();
            }
        }
        catch (IOException e) {
            Functions.printStackTrace((Throwable)e, listener.error(Messages.Fingerprinter_Failed()));
            build.setResult(Result.FAILURE);
        }
    }

    @Override
    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Override
    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (enableFingerprintsInDependencyGraph) {
            List builds = owner.getBuilds();
            HashSet<String> seenUpstreamProjects = new HashSet<String>();
            for (Object build1 : builds) {
                Run build = (Run)build1;
                for (FingerprintAction action : build.getActions(FingerprintAction.class)) {
                    for (AbstractProject<?, ?> abstractProject : action.getDependencies().keySet()) {
                        if (abstractProject == owner) continue;
                        AbstractProject<?, ?> p = abstractProject;
                        if (abstractProject.getClass().getName().equals("hudson.matrix.MatrixConfiguration")) {
                            p = abstractProject.getRootProject();
                        }
                        if (seenUpstreamProjects.contains(p.getName())) continue;
                        seenUpstreamProjects.add(p.getName());
                        graph.addDependency(new DependencyGraph.Dependency(p, owner){

                            @Override
                            public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
                                return false;
                            }
                        });
                    }
                }
            }
        }
    }

    private void record(Run<?, ?> build, FilePath ws, TaskListener listener, Map<String, String> record, String targets) throws IOException, InterruptedException {
        for (Record r : ws.act(new FindRecords(targets, this.excludes, this.defaultExcludes, this.caseSensitive, build.getTimeInMillis()))) {
            Fingerprint fp = r.addRecord(build);
            if (fp == null) {
                listener.error(Messages.Fingerprinter_FailedFor(r.relativePath));
                continue;
            }
            fp.addFor(build);
            record.put(r.relativePath, fp.getHashString());
        }
    }

    public static final class FingerprintAction
    implements RunAction2 {
        private transient Run build;
        private PackedMap<String, String> record;
        private transient WeakReference<Map<String, Fingerprint>> ref;

        public FingerprintAction(Run build, Map<String, String> record) {
            this.build = build;
            this.record = this.compact(record);
        }

        @Deprecated
        public FingerprintAction(AbstractBuild build, Map<String, String> record) {
            this((Run)build, record);
        }

        public void add(Map<String, String> moreRecords) {
            HashMap<String, String> r = new HashMap<String, String>(this.record);
            r.putAll(moreRecords);
            this.record = this.compact(r);
            this.ref = null;
        }

        @Override
        public String getIconFileName() {
            return "fingerprint.png";
        }

        @Override
        public String getDisplayName() {
            return Messages.Fingerprinter_Action_DisplayName();
        }

        @Override
        public String getUrlName() {
            return "fingerprints";
        }

        public Run getRun() {
            return this.build;
        }

        @Deprecated
        public AbstractBuild getBuild() {
            return this.build instanceof AbstractBuild ? (AbstractBuild)this.build : null;
        }

        public Map<String, String> getRecords() {
            return this.record;
        }

        @Override
        public void onLoad(Run<?, ?> r) {
            this.build = r;
            this.record = this.compact(this.record);
        }

        @Override
        public void onAttached(Run<?, ?> r) {
        }

        private PackedMap<String, String> compact(Map<String, String> record) {
            HashMap<String, String> b = new HashMap<String, String>();
            for (Map.Entry<String, String> e : record.entrySet()) {
                b.put(e.getKey().intern(), e.getValue().intern());
            }
            return PackedMap.of(b);
        }

        public synchronized Map<String, Fingerprint> getFingerprints() {
            Map m;
            if (this.ref != null && (m = (Map)this.ref.get()) != null) {
                return m;
            }
            Jenkins h = Jenkins.get();
            TreeMap<String, Fingerprint> m2 = new TreeMap();
            for (Map.Entry<String, String> r : this.record.entrySet()) {
                try {
                    Fingerprint fp = h._getFingerprint(r.getValue());
                    if (fp == null) continue;
                    m2.put(r.getKey(), fp);
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            m2 = Collections.unmodifiableMap(m2);
            this.ref = new WeakReference(m2);
            return m2;
        }

        public Map<AbstractProject, Integer> getDependencies() {
            return this.getDependencies(false);
        }

        public Map<AbstractProject, Integer> getDependencies(boolean includeMissing) {
            HashMap<AbstractProject, Integer> r = new HashMap<AbstractProject, Integer>();
            for (Fingerprint fp : this.getFingerprints().values()) {
                Fingerprint.BuildPtr bp = fp.getOriginal();
                if (bp == null || bp.is(this.build)) continue;
                try {
                    Integer existing;
                    Job<?, ?> job = bp.getJob();
                    if (job == null || !(job instanceof AbstractProject) || job.getParent() == this.build.getParent() || !includeMissing && job.getBuildByNumber(bp.getNumber()) == null || (existing = (Integer)r.get(job)) != null && existing > bp.getNumber()) continue;
                    r.put((AbstractProject)job, bp.getNumber());
                }
                catch (AccessDeniedException e) {}
            }
            return r;
        }
    }

    @Extension
    @Symbol(value={"fingerprint"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @Override
        public String getDisplayName() {
            return Messages.Fingerprinter_DisplayName();
        }

        @Deprecated
        public FormValidation doCheck(@AncestorInPath AbstractProject project, @QueryParameter String value) throws IOException {
            return this.doCheckTargets(project, value);
        }

        public FormValidation doCheckTargets(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException {
            if (project == null) {
                return FormValidation.ok();
            }
            return FilePath.validateFileMask(project.getSomeWorkspace(), value);
        }

        @Override
        public Publisher newInstance(StaplerRequest req, JSONObject formData) {
            return (Publisher)req.bindJSON(Fingerprinter.class, formData);
        }

        @Override
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }

    private static final class FindRecords
    extends MasterToSlaveFileCallable<List<Record>> {
        private final String targets;
        private final String excludes;
        private final boolean defaultExcludes;
        private final boolean caseSensitive;
        private final long buildTimestamp;

        FindRecords(String targets, String excludes, boolean defaultExcludes, boolean caseSensitive, long buildTimestamp) {
            this.targets = targets;
            this.excludes = excludes;
            this.defaultExcludes = defaultExcludes;
            this.caseSensitive = caseSensitive;
            this.buildTimestamp = buildTimestamp;
        }

        @Override
        public List<Record> invoke(File baseDir, VirtualChannel channel) throws IOException {
            ArrayList<Record> results = new ArrayList<Record>();
            FileSet src = Util.createFileSet(baseDir, this.targets, this.excludes);
            src.setDefaultexcludes(this.defaultExcludes);
            src.setCaseSensitive(this.caseSensitive);
            DirectoryScanner ds = src.getDirectoryScanner();
            for (String f : ds.getIncludedFiles()) {
                File file = new File(baseDir, f);
                boolean produced = this.buildTimestamp <= file.lastModified() + 2000L;
                try {
                    results.add(new Record(produced, f, file.getName(), new FilePath(file).digest()));
                }
                catch (IOException e) {
                    throw new IOException(Messages.Fingerprinter_DigestFailed(file), e);
                }
                catch (InterruptedException e) {
                    throw new IOException(Messages.Fingerprinter_Aborted(), e);
                }
            }
            return results;
        }
    }

    private static final class Record
    implements Serializable {
        final boolean produced;
        final String relativePath;
        final String fileName;
        final String md5sum;
        private static final long serialVersionUID = 1L;

        Record(boolean produced, String relativePath, String fileName, String md5sum) {
            this.produced = produced;
            this.relativePath = relativePath;
            this.fileName = fileName;
            this.md5sum = md5sum;
        }

        Fingerprint addRecord(Run build) throws IOException {
            FingerprintMap map = Jenkins.get().getFingerprintMap();
            return map.getOrCreate(this.produced ? build : null, this.fileName, this.md5sum);
        }
    }
}

