/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.model.User;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;

public abstract class UserAvatarResolver
implements ExtensionPoint {
    static Pattern iconSizeRegex = Pattern.compile("(\\d+)x(\\d+)");
    private static final Logger LOGGER = Logger.getLogger(UserAvatarResolver.class.getName());

    public abstract String findAvatarFor(User var1, int var2, int var3);

    public static String resolve(User u, String avatarSize) {
        String avatar = UserAvatarResolver.resolveOrNull(u, avatarSize);
        return avatar != null ? avatar : Jenkins.get().getRootUrl() + Functions.getResourcePath() + "/images/" + avatarSize + "/user.png";
    }

    @CheckForNull
    public static String resolveOrNull(User u, String avatarSize) {
        Matcher matcher = iconSizeRegex.matcher(avatarSize);
        if (matcher.matches() && matcher.groupCount() == 2) {
            int width = Integer.parseInt(matcher.group(1));
            int height = Integer.parseInt(matcher.group(2));
            for (UserAvatarResolver r : UserAvatarResolver.all()) {
                String name = r.findAvatarFor(u, width, height);
                if (name == null) continue;
                return name;
            }
        } else {
            LOGGER.warning(String.format("Could not split up the avatar size (%s) into a width and height.", avatarSize));
        }
        return null;
    }

    public static ExtensionList<UserAvatarResolver> all() {
        return ExtensionList.lookup(UserAvatarResolver.class);
    }
}

