/*
 * Decompiled with CFR 0.152.
 */
package hudson.tools;

import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.Messages;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractCommandInstaller
extends ToolInstaller {
    private final String command;
    private final String toolHome;

    public AbstractCommandInstaller(String label, String command, String toolHome) {
        super(label);
        this.command = command;
        this.toolHome = toolHome;
    }

    public String getCommand() {
        return this.command;
    }

    public String getToolHome() {
        return this.toolHome;
    }

    public abstract String getCommandFileExtension();

    public abstract String[] getCommandCall(FilePath var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath dir = this.preferredLocation(tool, node);
        FilePath script = dir.createTextTempFile("hudson", this.getCommandFileExtension(), this.command);
        try {
            String[] cmd = this.getCommandCall(script);
            int r = node.createLauncher(log).launch().cmds(cmd).stdout(log).pwd(dir).join();
            if (r != 0) {
                throw new IOException("Command returned status " + r);
            }
        }
        finally {
            script.delete();
        }
        return dir.child(this.getToolHome());
    }

    public static abstract class Descriptor<TInstallerClass extends AbstractCommandInstaller>
    extends ToolInstallerDescriptor<TInstallerClass> {
        public FormValidation doCheckCommand(@QueryParameter String value) {
            if (value.length() > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error(Messages.CommandInstaller_no_command());
        }

        public FormValidation doCheckToolHome(@QueryParameter String value) {
            if (value.length() > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error(Messages.CommandInstaller_no_toolHome());
        }
    }
}

