/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class HttpResponses
extends org.kohsuke.stapler.HttpResponses {
    public static HttpResponse staticResource(File f) throws IOException {
        return HttpResponses.staticResource((URL)f.toURI().toURL());
    }

    public static HttpResponse okJSON() {
        return new JSONObjectResponse();
    }

    public static HttpResponse okJSON(@NonNull JSONObject data) {
        return new JSONObjectResponse(data);
    }

    public static HttpResponse okJSON(@NonNull JSONArray data) {
        return new JSONObjectResponse(data);
    }

    public static HttpResponse okJSON(@NonNull Map<?, ?> data) {
        return new JSONObjectResponse(data);
    }

    public static HttpResponse errorJSON(@NonNull String message) {
        return new JSONObjectResponse().error(message);
    }

    public static HttpResponse errorJSON(@NonNull String message, @NonNull Map<?, ?> data) {
        return new JSONObjectResponse(data).error(message);
    }

    public static HttpResponse errorJSON(@NonNull String message, @NonNull JSONObject data) {
        return new JSONObjectResponse(data).error(message);
    }

    public static HttpResponse errorJSON(@NonNull String message, @NonNull JSONArray data) {
        return new JSONObjectResponse(data).error(message);
    }

    static class JSONObjectResponse
    implements HttpResponse {
        private final JSONObject jsonObject = new JSONObject();

        JSONObjectResponse() {
            this.status("ok");
        }

        JSONObjectResponse(@NonNull JSONObject data) {
            this();
            this.jsonObject.put("data", (Object)data);
        }

        JSONObjectResponse(@NonNull JSONArray data) {
            this();
            this.jsonObject.put("data", (Object)data);
        }

        JSONObjectResponse(@NonNull Map<?, ?> data) {
            this();
            this.jsonObject.put("data", (Object)JSONObject.fromObject(data));
        }

        @NonNull
        JSONObjectResponse error(@NonNull String message) {
            this.status("error");
            this.jsonObject.put("message", (Object)message);
            return this;
        }

        @NonNull
        JSONObject getJsonObject() {
            return this.jsonObject;
        }

        @NonNull
        private JSONObjectResponse status(@NonNull String status) {
            this.jsonObject.put("status", (Object)status);
            return this;
        }

        public void generateResponse(StaplerRequest req, StaplerResponse rsp, Object node) throws IOException, ServletException {
            byte[] bytes = this.jsonObject.toString().getBytes(StandardCharsets.UTF_8);
            rsp.setContentType("application/json; charset=UTF-8");
            rsp.setContentLength(bytes.length);
            rsp.getOutputStream().write(bytes);
        }
    }
}

