/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.ArrayUtils;

public class MultipartFormDataParser
implements AutoCloseable {
    private final ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
    private final Map<String, FileItem> byName = new HashMap<String, FileItem>();

    public MultipartFormDataParser(HttpServletRequest request) throws ServletException {
        try {
            for (FileItem fi : this.upload.parseRequest(request)) {
                this.byName.put(fi.getFieldName(), fi);
            }
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String get(String key) {
        FileItem fi = this.byName.get(key);
        if (fi == null) {
            return null;
        }
        return fi.getString();
    }

    public FileItem getFileItem(String key) {
        return this.byName.get(key);
    }

    public void cleanUp() {
        for (FileItem item : this.byName.values()) {
            item.delete();
        }
    }

    @Override
    public void close() {
        this.cleanUp();
    }

    public static boolean isMultiPartForm(@CheckForNull String contentType) {
        if (contentType == null) {
            return false;
        }
        Object[] parts = contentType.split(";");
        return ArrayUtils.contains((Object[])parts, (Object)"multipart/form-data");
    }
}

