/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.CreatesObligation;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.util.AtomicFileWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.stream.Stream;
import jenkins.util.io.LinesStream;

public class TextFile {
    @NonNull
    public final File file;

    public TextFile(@NonNull File file) {
        this.file = file;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void delete() {
        this.file.delete();
    }

    public String read() throws IOException {
        StringWriter out = new StringWriter();
        PrintWriter w = new PrintWriter(out);
        try (BufferedReader in = Files.newBufferedReader(Util.fileToPath(this.file), StandardCharsets.UTF_8);){
            String line;
            while ((line = in.readLine()) != null) {
                w.println(line);
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to fully read " + this.file, e);
        }
        return out.toString();
    }

    @Deprecated
    @NonNull
    public Iterable<String> lines() {
        try {
            return this.linesStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @NonNull
    public Stream<String> lines2() throws IOException {
        return Files.lines(Util.fileToPath(this.file));
    }

    @CreatesObligation
    @Deprecated
    @NonNull
    public LinesStream linesStream() throws IOException {
        return new LinesStream(Util.fileToPath(this.file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String text) throws IOException {
        this.file.getParentFile().mkdirs();
        try (AtomicFileWriter w = new AtomicFileWriter(this.file);){
            try {
                w.write(text);
                w.commit();
            }
            finally {
                w.abort();
            }
        }
    }

    @NonNull
    public String head(int numChars) throws IOException {
        char[] buf = new char[numChars];
        try (FileReader r = new FileReader(this.file);){
            int read;
            int d;
            for (read = 0; read < numChars && (d = ((Reader)r).read(buf, read, buf.length - read)) >= 0; read += d) {
            }
            String string = new String(buf, 0, read);
            return string;
        }
    }

    @NonNull
    public String fastTail(int numChars, Charset cs) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(this.file, "r");){
            long len = raf.length();
            long pos = Math.max(0L, len - (long)(numChars * 4 + 1024));
            raf.seek(pos);
            byte[] tail = new byte[(int)(len - pos)];
            raf.readFully(tail);
            String tails = cs.decode(ByteBuffer.wrap(tail)).toString();
            String string = tails.substring(Math.max(0, tails.length() - numChars));
            return string;
        }
    }

    @NonNull
    public String fastTail(int numChars) throws IOException {
        return this.fastTail(numChars, Charset.defaultCharset());
    }

    public String readTrim() throws IOException {
        return this.read().trim();
    }

    public String toString() {
        return this.file.toString();
    }
}

