/*
 * Decompiled with CFR 0.152.
 */
package jenkins;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import java.net.URL;
import jenkins.PluginLocaleDrivenResourceProvider;
import org.apache.log4j.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.LocaleDrivenResourceProvider;

@Restricted(value={NoExternalUse.class})
public final class MetaLocaleDrivenResourceProvider
extends LocaleDrivenResourceProvider {
    private static final Logger LOGGER = Logger.getLogger((String)MetaLocaleDrivenResourceProvider.class.getName());

    @CheckForNull
    public URL lookup(@NonNull String s) {
        for (PluginLocaleDrivenResourceProvider provider : ExtensionList.lookup(PluginLocaleDrivenResourceProvider.class)) {
            try {
                URL url = provider.lookup(s);
                if (url == null) continue;
                return url;
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Failed to lookup URL for '" + s + "' from '" + provider.toString()), (Throwable)e);
            }
        }
        return null;
    }
}

