/*
 * Decompiled with CFR 0.152.
 */
package jenkins;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import java.io.File;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.FilePathFilter;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public final class SoloFilePathFilter
extends FilePathFilter {
    private static final Logger LOGGER = Logger.getLogger(SoloFilePathFilter.class.getName());
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean REDACT_ERRORS = SystemProperties.getBoolean(SoloFilePathFilter.class.getName() + ".redactErrors", true);
    private final FilePathFilter base;

    private SoloFilePathFilter(FilePathFilter base) {
        this.base = base;
    }

    @Nullable
    public static SoloFilePathFilter wrap(@Nullable FilePathFilter base) {
        if (base == null) {
            return null;
        }
        return new SoloFilePathFilter(base);
    }

    private boolean noFalse(String op, File f, boolean b) {
        if (!b) {
            String detailedMessage = "Agent may not '" + op + "' at '" + f + "'. See https://www.jenkins.io/redirect/security-144 for more information.";
            if (REDACT_ERRORS) {
                UUID uuid = UUID.randomUUID();
                LOGGER.log(Level.WARNING, () -> uuid + ": " + detailedMessage);
                throw new SecurityException("Agent may not access a file path. See the system log for more details about the error ID '" + uuid + "' and https://www.jenkins.io/redirect/security-144 for more information.");
            }
            throw new SecurityException(detailedMessage);
        }
        return true;
    }

    private File normalize(File file) {
        return new File(FilePath.normalize(file.getAbsolutePath()));
    }

    @Override
    public boolean read(File f) throws SecurityException {
        return this.noFalse("read", f, this.base.read(this.normalize(f)));
    }

    @Override
    public boolean write(File f) throws SecurityException {
        return this.noFalse("write", f, this.base.write(this.normalize(f)));
    }

    @Override
    public boolean symlink(File f) throws SecurityException {
        return this.noFalse("symlink", f, this.base.symlink(this.normalize(f)));
    }

    @Override
    public boolean mkdirs(File f) throws SecurityException {
        for (File reference = this.normalize(f); reference != null && !reference.exists(); reference = reference.getParentFile()) {
            this.noFalse("mkdirs", f, this.base.mkdirs(reference));
        }
        return true;
    }

    @Override
    public boolean create(File f) throws SecurityException {
        return this.noFalse("create", f, this.base.create(this.normalize(f)));
    }

    @Override
    public boolean delete(File f) throws SecurityException {
        return this.noFalse("delete", f, this.base.delete(this.normalize(f)));
    }

    @Override
    public boolean stat(File f) throws SecurityException {
        return this.noFalse("stat", f, this.base.stat(this.normalize(f)));
    }
}

