/*
 * Decompiled with CFR 0.152.
 */
package jenkins.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.args4j.Argument;

@Extension
@Restricted(value={NoExternalUse.class})
public class StopBuildsCommand
extends CLICommand {
    @Argument(usage="Name of the job(s) to stop", required=true, multiValued=true)
    private List<String> jobNames;
    private boolean isAnyBuildStopped;

    @Override
    public String getShortDescription() {
        return "Stop all running builds for job(s)";
    }

    @Override
    protected int run() throws Exception {
        Jenkins jenkins = Jenkins.get();
        HashSet<String> names = new HashSet<String>(this.jobNames);
        ArrayList<Job> jobsToStop = new ArrayList<Job>();
        for (String jobName : names) {
            Item item = jenkins.getItemByFullName(jobName);
            if (item instanceof Job) {
                jobsToStop.add((Job)item);
                continue;
            }
            throw new IllegalArgumentException("Job not found: '" + jobName + "'");
        }
        for (Job job : jobsToStop) {
            this.stopJobBuilds(job);
        }
        if (!this.isAnyBuildStopped) {
            this.stdout.println("No builds stopped");
        }
        return 0;
    }

    private void stopJobBuilds(Job job) {
        Object lastBuild = job.getLastBuild();
        String jobName = job.getFullDisplayName();
        if (lastBuild != null && ((Run)lastBuild).isBuilding()) {
            this.stopBuild((Run)lastBuild, jobName);
            this.checkAndStopPreviousBuilds((Run)lastBuild, jobName);
        }
    }

    private void stopBuild(Run build, String jobName) {
        String buildName = build.getDisplayName();
        Executor executor = build.getExecutor();
        if (executor != null) {
            try {
                executor.doStop();
                this.isAnyBuildStopped = true;
                this.stdout.printf("Build '%s' stopped for job '%s'%n", buildName, jobName);
            }
            catch (Exception e) {
                this.stdout.printf("Exception occurred while trying to stop build '%s' for job '%s'. ", buildName, jobName);
                this.stdout.printf("Exception class: %s, message: %s%n", e.getClass().getSimpleName(), e.getMessage());
            }
        } else {
            this.stdout.printf("Build '%s' in job '%s' not stopped%n", buildName, jobName);
        }
    }

    private void checkAndStopPreviousBuilds(Run lastBuild, String jobName) {
        for (Object build = lastBuild.getPreviousBuildInProgress(); build != null; build = ((Run)build).getPreviousBuildInProgress()) {
            this.stopBuild((Run)build, jobName);
        }
    }
}

