/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.lazy;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.util.AdaptedIterator;
import hudson.util.Iterators;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import jenkins.model.lazy.AbstractLazyLoadRunMap;
import jenkins.model.lazy.BuildReference;

class BuildReferenceMapAdapter<R>
implements SortedMap<Integer, R> {
    private final AbstractLazyLoadRunMap<R> loader;
    private final SortedMap<Integer, BuildReference<R>> core;

    BuildReferenceMapAdapter(AbstractLazyLoadRunMap<R> loader, SortedMap<Integer, BuildReference<R>> core) {
        this.loader = loader;
        this.core = core;
    }

    private R unwrap(@Nullable BuildReference<R> ref) {
        if (ref == null) {
            return null;
        }
        R v = ref.get();
        if (v == null) {
            v = this.loader.getById(ref.id);
        }
        return v;
    }

    private BuildReference<R> wrap(@Nullable R value) {
        if (value == null) {
            return null;
        }
        return this.loader.createReference(value);
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return this.core.comparator();
    }

    @Override
    public SortedMap<Integer, R> subMap(Integer fromKey, Integer toKey) {
        return new BuildReferenceMapAdapter<R>(this.loader, this.core.subMap(fromKey, toKey));
    }

    @Override
    public SortedMap<Integer, R> headMap(Integer toKey) {
        return new BuildReferenceMapAdapter<R>(this.loader, this.core.headMap(toKey));
    }

    @Override
    public SortedMap<Integer, R> tailMap(Integer fromKey) {
        return new BuildReferenceMapAdapter<R>(this.loader, this.core.tailMap(fromKey));
    }

    @Override
    public Integer firstKey() {
        return this.core.firstKey();
    }

    @Override
    public Integer lastKey() {
        return this.core.lastKey();
    }

    @Override
    public Set<Integer> keySet() {
        return this.core.keySet();
    }

    @Override
    public Collection<R> values() {
        return new CollectionAdapter(this.core.values());
    }

    @Override
    public Set<Map.Entry<Integer, R>> entrySet() {
        return new SetAdapter(this.core.entrySet());
    }

    @Override
    public int size() {
        return this.core.size();
    }

    @Override
    public boolean isEmpty() {
        return this.core.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.core.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.core.containsValue(value);
    }

    @Override
    public R get(Object key) {
        return this.unwrap((BuildReference)this.core.get(key));
    }

    @Override
    public R put(Integer key, R value) {
        return this.unwrap(this.core.put(key, this.wrap(value)));
    }

    @Override
    public R remove(Object key) {
        return this.unwrap((BuildReference)this.core.remove(key));
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends R> m) {
        for (Map.Entry<Integer, R> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.core.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.core.equals(o);
    }

    @Override
    public int hashCode() {
        return this.core.hashCode();
    }

    public String toString() {
        return new LinkedHashMap(this).toString();
    }

    private class SetAdapter
    implements Set<Map.Entry<Integer, R>> {
        private final Set<Map.Entry<Integer, BuildReference<R>>> core;

        private SetAdapter(Set<Map.Entry<Integer, BuildReference<R>>> core) {
            this.core = core;
        }

        @Override
        public int size() {
            return this.core.size();
        }

        @Override
        public boolean isEmpty() {
            return this.core.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Map.Entry<Integer, R>> iterator() {
            return Iterators.removeNull(new AdaptedIterator<Map.Entry<Integer, BuildReference<R>>, Map.Entry<Integer, R>>(this.core.iterator()){

                @Override
                protected Map.Entry<Integer, R> adapt(Map.Entry<Integer, BuildReference<R>> e) {
                    return SetAdapter.this._unwrap(e);
                }
            });
        }

        @Override
        public Object[] toArray() {
            ArrayList list = new ArrayList(this);
            return list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] r = a;
            int size = this.size();
            if (r.length > size) {
                r = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Iterator itr = this.iterator();
            int i = 0;
            while (itr.hasNext()) {
                r[i++] = itr.next();
            }
            return r;
        }

        @Override
        public boolean add(Map.Entry<Integer, R> value) {
            return this.core.add(this._wrap(value));
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Integer, R>> c) {
            boolean b = false;
            for (Map.Entry r : c) {
                b |= this.add(r);
            }
            return b;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean b = false;
            for (Object o : c) {
                b |= this.remove(o);
            }
            return b;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.core.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.core.equals(o);
        }

        @Override
        public int hashCode() {
            return this.core.hashCode();
        }

        private Map.Entry<Integer, BuildReference<R>> _wrap(Map.Entry<Integer, R> e) {
            return new AbstractMap.SimpleEntry(e.getKey(), BuildReferenceMapAdapter.this.wrap(e.getValue()));
        }

        private Map.Entry<Integer, R> _unwrap(Map.Entry<Integer, BuildReference<R>> e) {
            Object v = BuildReferenceMapAdapter.this.unwrap(e.getValue());
            if (v == null) {
                return null;
            }
            return new AbstractMap.SimpleEntry<Integer, Object>(e.getKey(), v);
        }
    }

    private class CollectionAdapter
    implements Collection<R> {
        private final Collection<BuildReference<R>> core;

        private CollectionAdapter(Collection<BuildReference<R>> core) {
            this.core = core;
        }

        @Override
        public int size() {
            return this.core.size();
        }

        @Override
        public boolean isEmpty() {
            return this.core.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<R> iterator() {
            return Iterators.removeNull(new AdaptedIterator<BuildReference<R>, R>(this.core.iterator()){

                @Override
                protected R adapt(BuildReference<R> ref) {
                    return BuildReferenceMapAdapter.this.unwrap(ref);
                }
            });
        }

        @Override
        public Object[] toArray() {
            ArrayList list = new ArrayList(this);
            return list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            Object[] r = a;
            int size = this.size();
            if (r.length > size) {
                r = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            Iterator itr = this.iterator();
            int i = 0;
            while (itr.hasNext()) {
                r[i++] = itr.next();
            }
            return r;
        }

        @Override
        public boolean add(R value) {
            return this.core.add(BuildReferenceMapAdapter.this.wrap(value));
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends R> c) {
            boolean b = false;
            for (Object r : c) {
                b |= this.add((R)r);
            }
            return b;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean b = false;
            for (Object o : c) {
                b |= this.remove(o);
            }
            return b;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            this.core.clear();
        }

        @Override
        public boolean equals(Object o) {
            return this.core.equals(o);
        }

        @Override
        public int hashCode() {
            return this.core.hashCode();
        }
    }
}

