/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.util.HttpResponses;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.s2m.CallableRejectionConfig;
import jenkins.security.s2m.CallableWhitelistConfig;
import jenkins.security.s2m.FilePathRuleConfig;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.remoting.Role;
import org.jenkinsci.remoting.RoleSensitive;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class AdminWhitelistRule
implements StaplerProxy {
    public final CallableRejectionConfig rejected;
    public final CallableWhitelistConfig whitelisted;
    public final FilePathRuleConfig filePathRules;
    private boolean masterKillSwitch;
    private static final Logger LOGGER = Logger.getLogger(AdminWhitelistRule.class.getName());

    public AdminWhitelistRule() throws IOException, InterruptedException {
        Jenkins jenkins = Jenkins.get();
        this.placeDefaultRule(new File(jenkins.getRootDir(), "secrets/whitelisted-callables.d/default.conf"), this.getClass().getResourceAsStream("callable.conf"));
        this.placeDefaultRule(new File(jenkins.getRootDir(), "secrets/filepath-filters.d/30-default.conf"), this.transformForWindows(this.getClass().getResourceAsStream("filepath-filter.conf")));
        this.whitelisted = new CallableWhitelistConfig(new File(jenkins.getRootDir(), "secrets/whitelisted-callables.d/gui.conf"));
        this.rejected = new CallableRejectionConfig(new File(jenkins.getRootDir(), "secrets/rejected-callables.txt"), this.whitelisted);
        this.filePathRules = new FilePathRuleConfig(new File(jenkins.getRootDir(), "secrets/filepath-filters.d/50-gui.conf"));
        File f = this.getMasterKillSwitchFile(jenkins);
        this.masterKillSwitch = this.loadMasterKillSwitchFile(f);
    }

    @CheckReturnValue
    private boolean loadMasterKillSwitchFile(@NonNull File f) {
        try {
            if (!f.exists()) {
                return true;
            }
            return Boolean.parseBoolean(FileUtils.readFileToString((File)f, (Charset)Charset.defaultCharset()).trim());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to read " + f, e);
            return false;
        }
    }

    @NonNull
    private File getMasterKillSwitchFile(@NonNull Jenkins jenkins) {
        return new File(jenkins.getRootDir(), "secrets/slave-to-master-security-kill-switch");
    }

    private InputStream transformForWindows(InputStream src) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(src));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (PrintStream p = new PrintStream(out);){
            String line;
            while ((line = r.readLine()) != null) {
                if (!line.startsWith("#") && Functions.isWindows()) {
                    line = line.replace("/", "\\\\");
                }
                p.println(line);
            }
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    private void placeDefaultRule(File f, InputStream src) throws IOException, InterruptedException {
        try {
            new FilePath(f).copyFrom(src);
        }
        catch (IOException e) {
            if (!f.canWrite()) {
                return;
            }
            LOGGER.log(Level.WARNING, "Failed to generate " + f, e);
        }
    }

    public boolean isWhitelisted(RoleSensitive subject, Collection<Role> expected, Object context) {
        if (this.masterKillSwitch) {
            return true;
        }
        String name = subject.getClass().getName();
        if (this.whitelisted.contains(name)) {
            return true;
        }
        this.rejected.report(subject.getClass());
        return false;
    }

    public boolean checkFileAccess(String op, File f) {
        if (this.masterKillSwitch) {
            return true;
        }
        return this.filePathRules.checkFileAccess(op, f);
    }

    @RequirePOST
    public HttpResponse doSubmit(StaplerRequest req) throws IOException {
        StringBuilder whitelist = new StringBuilder(Util.fixNull(req.getParameter("whitelist")));
        if (whitelist.length() > 0 && whitelist.charAt(whitelist.length() - 1) != '\n') {
            whitelist.append("\n");
        }
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith("class:")) continue;
            whitelist.append(name.substring(6)).append("\n");
        }
        this.whitelisted.set(whitelist.toString());
        String newRules = Util.fixNull(req.getParameter("filePathRules"));
        this.filePathRules.parseTest(newRules);
        this.filePathRules.set(newRules);
        return HttpResponses.redirectToDot();
    }

    @RequirePOST
    public HttpResponse doApproveAll() throws IOException {
        StringBuilder buf = new StringBuilder();
        for (Class c : (Set)this.rejected.get()) {
            buf.append(c.getName()).append('\n');
        }
        this.whitelisted.append(buf.toString());
        return HttpResponses.ok();
    }

    @RequirePOST
    public HttpResponse doApprove(@QueryParameter String value) throws IOException {
        this.whitelisted.append(value);
        return HttpResponses.ok();
    }

    public boolean getMasterKillSwitch() {
        return this.masterKillSwitch;
    }

    public void setMasterKillSwitch(boolean state) {
        Jenkins jenkins = Jenkins.get();
        try {
            jenkins.checkPermission(Jenkins.ADMINISTER);
            File f = this.getMasterKillSwitchFile(jenkins);
            FileUtils.writeStringToFile((File)f, (String)Boolean.toString(state), (Charset)Charset.defaultCharset());
            this.masterKillSwitch = this.loadMasterKillSwitchFile(f);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to write master kill switch", e);
        }
    }

    public Object getTarget() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return this;
    }
}

