/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import javax.inject.Inject;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.security.s2m.AdminWhitelistRule;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class MasterKillSwitchConfiguration
extends GlobalConfiguration {
    @Inject
    AdminWhitelistRule rule;
    @Inject
    Jenkins jenkins;

    @Override
    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public boolean getMasterToSlaveAccessControl() {
        return !this.rule.getMasterKillSwitch();
    }

    @Override
    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        if (this.isRelevant()) {
            this.rule.setMasterKillSwitch(!json.has("masterToSlaveAccessControl"));
        }
        return true;
    }

    public boolean isRelevant() {
        return true;
    }
}

