/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.s2m;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.remoting.ChannelBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.ReflectiveFilePathFilter;
import jenkins.model.Jenkins;
import jenkins.security.ChannelConfigurator;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class RunningBuildFilePathFilter
extends ReflectiveFilePathFilter {
    private static final String FAIL_PROPERTY = RunningBuildFilePathFilter.class.getName() + ".FAIL";
    private static final String SKIP_PROPERTY = RunningBuildFilePathFilter.class.getName() + ".SKIP";
    private static final Logger LOGGER = Logger.getLogger(RunningBuildFilePathFilter.class.getName());
    private final Object context;

    public RunningBuildFilePathFilter(Object context) {
        this.context = context;
    }

    @Override
    protected boolean op(String name, File path) throws SecurityException {
        String absolutePath;
        String patternString;
        if (SystemProperties.getBoolean(SKIP_PROPERTY)) {
            LOGGER.log(Level.FINE, () -> "Skipping check for '" + name + "' on '" + path + "'");
            return false;
        }
        Jenkins jenkins = Jenkins.get();
        try {
            patternString = Jenkins.expandVariablesForDirectory(jenkins.getRawBuildsDir(), "(.+)", "\\Q" + Jenkins.get().getRootDir().getCanonicalPath().replace('\\', '/') + "\\E/jobs/(.+)") + "/[0-9]+(/.*)?";
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to obtain canonical path to Jenkins home directory", e);
            throw new SecurityException("Failed to obtain canonical path");
        }
        Pattern pattern = Pattern.compile(patternString);
        try {
            absolutePath = path.getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to obtain canonical path to '" + path + "'", e);
            throw new SecurityException("Failed to obtain canonical path");
        }
        if (!pattern.matcher(absolutePath).matches()) {
            LOGGER.log(Level.FINE, "Not a build directory, so skipping: " + absolutePath);
            return false;
        }
        if (!(this.context instanceof Computer)) {
            LOGGER.warning(() -> "Unrecognized context " + this.context + " rejected for " + name + " on " + path);
            throw new SecurityException("Failed to discover context of access to build directory");
        }
        Computer c = (Computer)this.context;
        Path thePath = path.getAbsoluteFile().toPath();
        for (Executor executor : c.getExecutors()) {
            Path buildDir;
            Run<?, ?> build = RunningBuildFilePathFilter.findRun(executor.getCurrentExecutable());
            if (build == null || !thePath.startsWith(buildDir = build.getRootDir().getAbsoluteFile().toPath())) continue;
            return false;
        }
        String computerName = c.getName();
        if (SystemProperties.getBoolean(FAIL_PROPERTY, true)) {
            LOGGER.log(Level.WARNING, "Rejecting unexpected agent-to-controller file path access: Agent '" + computerName + "' is attempting to access '" + absolutePath + "' using operation '" + name + "'. Learn more: https://www.jenkins.io/redirect/security-144/");
            throw new SecurityException("Agent tried to access build directory of a build not currently running on this system. Learn more: https://www.jenkins.io/redirect/security-144/");
        }
        LOGGER.log(Level.WARNING, "Unexpected agent-to-controller file path access: Agent '" + computerName + "' is accessing '" + absolutePath + "' using operation '" + name + "'. Learn more: https://www.jenkins.io/redirect/security-144/");
        return false;
    }

    @CheckForNull
    private static Run<?, ?> findRun(@CheckForNull Queue.Executable exec) {
        if (exec == null) {
            return null;
        }
        if (exec instanceof Run) {
            return (Run)((Object)exec);
        }
        return RunningBuildFilePathFilter.findRun(exec.getParentExecutable());
    }

    @Extension
    public static class ChannelConfiguratorImpl
    extends ChannelConfigurator {
        @Override
        public void onChannelBuilding(ChannelBuilder builder, @Nullable Object context) {
            new RunningBuildFilePathFilter(context).installTo(builder, 150.0);
        }
    }
}

