/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.seed;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.Extension;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Objects;
import jenkins.model.Jenkins;
import jenkins.security.LastGrantedAuthoritiesProperty;
import jenkins.security.seed.Messages;
import jenkins.security.seed.UserSeedChangeListener;
import jenkins.util.SystemProperties;
import org.apache.commons.codec.binary.Hex;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class UserSeedProperty
extends UserProperty {
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean DISABLE_USER_SEED = SystemProperties.getBoolean(UserSeedProperty.class.getName() + ".disableUserSeed");
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean HIDE_USER_SEED_SECTION = SystemProperties.getBoolean(UserSeedProperty.class.getName() + ".hideUserSeedSection");
    public static final String USER_SESSION_SEED = "_JENKINS_SESSION_SEED";
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final int SEED_NUM_BYTES = 8;
    private String seed;

    private UserSeedProperty() {
        this.renewSeedInternal();
    }

    @NonNull
    public String getSeed() {
        return this.seed;
    }

    public void renewSeed() {
        this.renewSeedInternal();
        UserSeedChangeListener.fireUserSeedRenewed(this.user);
    }

    private void renewSeedInternal() {
        String currentSeed;
        String newSeed = currentSeed = this.seed;
        byte[] bytes = new byte[8];
        while (Objects.equals(newSeed, currentSeed)) {
            RANDOM.nextBytes(bytes);
            newSeed = new String(Hex.encodeHex((byte[])bytes));
        }
        this.seed = newSeed;
    }

    @Extension
    @Symbol(value={"userSeed"})
    public static final class DescriptorImpl
    extends UserPropertyDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.UserSeedProperty_DisplayName();
        }

        @Override
        public UserSeedProperty newInstance(User user) {
            return new UserSeedProperty();
        }

        @Restricted(value={DoNotUse.class})
        public boolean isCurrentUser(@NonNull User target) {
            return Objects.equals(User.current(), target);
        }

        @RequirePOST
        public synchronized HttpResponse doRenewSessionSeed(@AncestorInPath @NonNull User u) throws IOException {
            u.checkPermission(Jenkins.ADMINISTER);
            if (DISABLE_USER_SEED) {
                return HttpResponses.error((int)404, (String)"User seed feature is disabled");
            }
            try (BulkChange bc = new BulkChange(u);){
                UserSeedProperty p = u.getProperty(UserSeedProperty.class);
                p.renewSeed();
                LastGrantedAuthoritiesProperty lastGranted = u.getProperty(LastGrantedAuthoritiesProperty.class);
                if (lastGranted != null) {
                    lastGranted.invalidate();
                }
                bc.commit();
            }
            return HttpResponses.ok();
        }

        @Override
        public boolean isEnabled() {
            return !DISABLE_USER_SEED && !HIDE_USER_SEED_SECTION;
        }
    }
}

