/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Computer;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import jenkins.AgentProtocol;
import jenkins.model.identity.InstanceIdentityProvider;
import jenkins.slaves.IOHubProvider;
import jenkins.slaves.JnlpAgentReceiver;
import jenkins.slaves.Messages;
import org.jenkinsci.Symbol;
import org.jenkinsci.remoting.engine.JnlpProtocol4Handler;
import org.jenkinsci.remoting.protocol.cert.PublicKeyMatchingX509ExtendedTrustManager;

@Extension
@Symbol(value={"jnlp4"})
public class JnlpSlaveAgentProtocol4
extends AgentProtocol {
    private static final Logger LOGGER = Logger.getLogger(JnlpSlaveAgentProtocol4.class.getName());
    private final KeyStore keyStore;
    private final TrustManager trustManager;
    private IOHubProvider hub;
    private JnlpProtocol4Handler handler;
    private SSLContext sslContext;

    public JnlpSlaveAgentProtocol4() throws KeyStoreException, KeyManagementException, IOException {
        KeyManagerFactory kmf;
        X509Certificate identityCertificate = InstanceIdentityProvider.RSA.getCertificate();
        if (identityCertificate == null) {
            throw new KeyStoreException("JENKINS-41987: no X509Certificate found; perhaps instance-identity module is missing or too old");
        }
        RSAPrivateKey privateKey = InstanceIdentityProvider.RSA.getPrivateKey();
        if (privateKey == null) {
            throw new KeyStoreException("JENKINS-41987: no RSAPrivateKey found; perhaps instance-identity module is missing or too old");
        }
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] password = this.constructPassword();
        try {
            this.keyStore.load(null, password);
        }
        catch (IOException e) {
            throw new IllegalStateException("Specification says this should not happen as we are not doing I/O", e);
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException("Specification says this should not happen as we are not loading keys", e);
        }
        this.keyStore.setKeyEntry("jenkins", privateKey, password, new X509Certificate[]{identityCertificate});
        try {
            kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(this.keyStore, password);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Specification says the default algorithm should exist", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new IllegalStateException("The key was just inserted with this exact password", e);
        }
        this.trustManager = new PublicKeyMatchingX509ExtendedTrustManager(false, true, new PublicKey[0]);
        TrustManager[] trustManagers = new TrustManager[]{this.trustManager};
        try {
            this.sslContext = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Java runtime specification requires support for TLS algorithm", e);
        }
        this.sslContext.init(kmf.getKeyManagers(), trustManagers, null);
    }

    private char[] constructPassword() {
        return "password".toCharArray();
    }

    @Inject
    public void setHub(IOHubProvider hub) {
        this.hub = hub;
        this.handler = new JnlpProtocol4Handler(JnlpAgentReceiver.DATABASE, Computer.threadPoolForRemoting, hub.getHub(), this.sslContext, false, true);
    }

    @Override
    public boolean isOptIn() {
        return false;
    }

    @Override
    public String getDisplayName() {
        return Messages.JnlpSlaveAgentProtocol4_displayName();
    }

    @Override
    public String getName() {
        return this.handler.getName();
    }

    @Override
    public void handle(Socket socket) throws IOException, InterruptedException {
        try {
            X509Certificate certificate = (X509Certificate)this.keyStore.getCertificate("jenkins");
            if (certificate == null || certificate.getNotAfter().getTime() < System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L)) {
                LOGGER.log(Level.INFO, "Updating {0} TLS certificate to retain validity", this.getName());
                X509Certificate identityCertificate = InstanceIdentityProvider.RSA.getCertificate();
                RSAPrivateKey privateKey = InstanceIdentityProvider.RSA.getPrivateKey();
                char[] password = this.constructPassword();
                this.keyStore.setKeyEntry("jenkins", privateKey, password, new X509Certificate[]{identityCertificate});
            }
        }
        catch (KeyStoreException e) {
            LOGGER.log(Level.FINEST, "Ignored", e);
        }
        this.handler.handle(socket, Collections.singletonMap("JnlpAgentProtocol.cookie", JnlpAgentReceiver.generateCookie()), ExtensionList.lookup(JnlpAgentReceiver.class));
    }
}

