/*
 * Decompiled with CFR 0.152.
 */
package jenkins.tasks.filters;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import jenkins.tasks.filters.EnvVarsFilterGlobalRule;
import jenkins.tasks.filters.EnvVarsFilterRule;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public class EnvVarsFilterException
extends AbortException {
    private EnvVarsFilterRule rule;
    private String variableName;

    public EnvVarsFilterException(String message) {
        super(message);
    }

    @NonNull
    public EnvVarsFilterException withRule(@NonNull EnvVarsFilterRule rule) {
        this.rule = rule;
        return this;
    }

    @NonNull
    public EnvVarsFilterException withVariable(@NonNull String variableName) {
        this.variableName = variableName;
        return this;
    }

    @CheckForNull
    public EnvVarsFilterRule getRule() {
        return this.rule;
    }

    @Override
    @NonNull
    public String getMessage() {
        String message = super.getMessage();
        if (this.variableName != null) {
            message = message + " due to variable '" + this.variableName + "'";
        }
        if (this.rule != null) {
            message = this.rule instanceof EnvVarsFilterGlobalRule ? message + " detected by the global rule " + this.rule.getDisplayName() : message + " detected by " + this.rule.getDisplayName();
        }
        return message;
    }
}

