/*
 * Decompiled with CFR 0.152.
 */
package jenkins.telemetry.impl.java11;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.VersionNumber;
import io.jenkins.lib.versionnumber.JavaSpecificationVersion;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.telemetry.Telemetry;
import jenkins.telemetry.impl.java11.MissingClassEvent;
import jenkins.telemetry.impl.java11.MissingClassEvents;
import jenkins.util.java.JavaUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class MissingClassTelemetry
extends Telemetry {
    private static final Logger LOGGER = Logger.getLogger(MissingClassTelemetry.class.getName());
    private static MissingClassEvents events = new MissingClassEvents();
    private static final LocalDate START = LocalDate.of(2019, 4, 1);
    private static final LocalDate END = START.plusMonths(24L);
    private static final Set reportableExceptions = new HashSet<Class>(Arrays.asList(ClassNotFoundException.class, NoClassDefFoundError.class));
    @VisibleForTesting
    static final String CIRCULAR_REFERENCE = "Circular reference found on the exception we are analysing to report via telemetry";
    private static final String[] MOVED_PACKAGES = new String[]{"javax.activation", "javax.annotation", "javax.jws", "javax.rmi", "javax.transaction", "javax.xml.bind", "javax.xml.soap", "javax.xml.ws", "org.omg", "javax.activity", "com.sun", "sun"};
    private static String[][] IGNORED_PLACES = new String[][]{{"hudson.util.XStream2$AssociatedConverterImpl", "findConverter"}, {"org.jenkinsci.plugins.workflow.cps.global.GrapeHack", "hack"}, {"org.codehaus.groovy.runtime.callsite.CallSiteArray", "createCallStaticSite"}, {"groovy.lang.MetaClassImpl", "addProperties"}, {"hudson.PluginManager.UberClassLoader", "findClass"}, {"hudson.ExtensionFinder$GuiceFinder$FaultTolerantScope$1", "get"}, {"hudson.ExtensionFinder$GuiceFinder$SezpozModule", "resolve"}, {"java.beans.Introspector", "findCustomizerClass"}, {"com.sun.beans.finder.InstanceFinder", "instantiate"}, {"com.sun.beans.finder.ClassFinder", "findClass"}, {"java.util.ResourceBundle$Control", "newBundle"}, {"org.codehaus.groovy.control.ClassNodeResolver", "tryAsLoaderClassOrScript"}, {"org.kohsuke.stapler.RequestImpl$TypePair", "convertJSON"}, {"net.bull.javamelody.FilterContext", "isMojarraAvailable"}, {"hudson.remoting.RemoteClassLoader$ClassLoaderProxy", "fetch3"}, {"sun.reflect.generics.factory.CoreReflectionFactory", "makeNamedType"}};

    @Override
    @NonNull
    public String getDisplayName() {
        return "Missing classes related with Java updates";
    }

    @Override
    @NonNull
    public LocalDate getStart() {
        return START;
    }

    @Override
    @NonNull
    public LocalDate getEnd() {
        return END;
    }

    @VisibleForTesting
    static MissingClassEvents getEvents() {
        return events;
    }

    public static boolean enabled() {
        return JavaUtils.getCurrentJavaRuntimeVersionNumber().isNewerThan((VersionNumber)JavaSpecificationVersion.JAVA_8);
    }

    @Override
    @CheckForNull
    public JSONObject createContent() {
        if (!MissingClassTelemetry.enabled()) {
            return null;
        }
        JSONArray events = this.formatEventsAndInitialize();
        if (events.size() == 0) {
            return null;
        }
        JSONObject info = new JSONObject();
        VersionNumber jenkinsVersion = Jenkins.getVersion();
        info.put("core", (Object)(jenkinsVersion != null ? jenkinsVersion.toString() : "UNKNOWN"));
        info.put("clientDate", (Object)MissingClassTelemetry.clientDateString());
        info.put("classMissingEvents", (Object)events);
        return JSONObject.fromObject((Object)info);
    }

    @NonNull
    private JSONArray formatEventsAndInitialize() {
        ConcurrentHashMap<List<StackTraceElement>, MissingClassEvent> toReport = events.getEventsAndClean();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Cleaned events for missing classes");
        }
        return this.formatEvents(toReport);
    }

    @NonNull
    private JSONArray formatEvents(@NonNull ConcurrentHashMap<List<StackTraceElement>, MissingClassEvent> events) {
        JSONArray jsonEvents = new JSONArray();
        events.forEach((stackTrace, event) -> {
            JSONObject eventObject = new JSONObject();
            eventObject.put("className", (Object)event.getClassName());
            eventObject.put("class", (Object)event.getClassName());
            eventObject.put("time", (Object)event.getTime());
            eventObject.put("occurrences", (Object)Long.toString(event.getOccurrences()));
            eventObject.put("stacktrace", (Object)event.getStackTrace());
            jsonEvents.add((Object)eventObject);
        });
        return jsonEvents;
    }

    @NonNull
    static String clientDateString() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        df.setTimeZone(tz);
        return df.format(new Date());
    }

    public static void reportException(@NonNull String name, @NonNull Throwable e) {
        if (MissingClassTelemetry.enabled() && MissingClassTelemetry.isFromMovedPackage(name = name.replace('/', '.').trim()) && !MissingClassTelemetry.calledFromIgnoredPlace(e)) {
            if (LOGGER.isLoggable(Level.WARNING) && !MissingClassTelemetry.wasAlreadyReported(name)) {
                LOGGER.log(Level.WARNING, "Added a missed class for missing class telemetry. Class: " + name, e);
            }
            events.put(name, e);
        }
    }

    private static boolean wasAlreadyReported(@NonNull String className) {
        return events.alreadyRegistered(className);
    }

    private static boolean calledFromIgnoredPlace(@NonNull Throwable throwable) {
        for (String[] ignoredPlace : IGNORED_PLACES) {
            if (!MissingClassTelemetry.calledFrom(throwable, ignoredPlace[0], ignoredPlace[1])) continue;
            return true;
        }
        return false;
    }

    private static boolean calledFrom(@NonNull Throwable throwable, @NonNull String clazz, @NonNull String method) {
        StackTraceElement[] trace;
        for (StackTraceElement el : trace = throwable.getStackTrace()) {
            if (!clazz.equals(el.getClassName()) || !el.getMethodName().equals(method)) continue;
            return true;
        }
        return false;
    }

    private static void reportException(@NonNull Throwable e) {
        if (MissingClassTelemetry.enabled()) {
            String name = e.getMessage();
            if (name == null || name.trim().isEmpty()) {
                LOGGER.log(Level.INFO, "No class name could be extracted from the throwable to determine if it's reportable", e);
            } else {
                MissingClassTelemetry.reportException(name, e);
            }
        }
    }

    private static boolean isFromMovedPackage(@NonNull String clazz) {
        for (String movedPackage : MOVED_PACKAGES) {
            if (!clazz.startsWith(movedPackage)) continue;
            return true;
        }
        return false;
    }

    public static void reportExceptionInside(@NonNull Throwable e) {
        if (MissingClassTelemetry.enabled()) {
            Set<Throwable> exceptionsReviewed = Collections.newSetFromMap(new IdentityHashMap());
            MissingClassTelemetry.reportExceptionInside(e, exceptionsReviewed);
        }
    }

    private static boolean reportExceptionInside(@NonNull Throwable e, @NonNull Set<Throwable> exceptionsReviewed) {
        if (exceptionsReviewed.contains(e)) {
            LOGGER.log(Level.WARNING, CIRCULAR_REFERENCE, e);
            return false;
        }
        exceptionsReviewed.add(e);
        if (MissingClassTelemetry.isMissedClassRelatedException(e)) {
            MissingClassTelemetry.reportException(e);
            return true;
        }
        if (e.getCause() != null && MissingClassTelemetry.reportExceptionInside(e.getCause(), exceptionsReviewed)) {
            return true;
        }
        for (Throwable suppressed : e.getSuppressed()) {
            if (suppressed == null || !MissingClassTelemetry.reportExceptionInside(suppressed, exceptionsReviewed)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMissedClassRelatedException(Throwable e) {
        return reportableExceptions.contains(e.getClass());
    }
}

