/*
 * Decompiled with CFR 0.152.
 */
package jenkins.websocket;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;
import jenkins.util.Timer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public abstract class WebSocketSession {
    private static long PING_INTERVAL_SECONDS = SystemProperties.getLong("jenkins.websocket.pingInterval", 30L);
    private static final Logger LOGGER = Logger.getLogger(WebSocketSession.class.getName());
    private Object session;
    private Object remoteEndpoint;
    private ScheduledFuture<?> pings;

    protected WebSocketSession() {
    }

    Object onWebSocketSomething(Object proxy, Method method, Object[] args) throws Exception {
        switch (method.getName()) {
            case "onWebSocketConnect": {
                this.session = args[0];
                this.remoteEndpoint = this.session.getClass().getMethod("getRemote", new Class[0]).invoke(args[0], new Object[0]);
                if (PING_INTERVAL_SECONDS != 0L) {
                    this.pings = Timer.get().scheduleAtFixedRate(() -> {
                        try {
                            this.remoteEndpoint.getClass().getMethod("sendPing", ByteBuffer.class).invoke(this.remoteEndpoint, ByteBuffer.wrap(new byte[0]));
                        }
                        catch (Exception x) {
                            this.error(x);
                            this.pings.cancel(true);
                        }
                    }, PING_INTERVAL_SECONDS / 2L, PING_INTERVAL_SECONDS, TimeUnit.SECONDS);
                }
                this.opened();
                return null;
            }
            case "onWebSocketClose": {
                if (this.pings != null) {
                    this.pings.cancel(true);
                }
                this.closed((Integer)args[0], (String)args[1]);
                return null;
            }
            case "onWebSocketError": {
                this.error((Throwable)args[0]);
                return null;
            }
            case "onWebSocketBinary": {
                this.binary((byte[])args[0], (Integer)args[1], (Integer)args[2]);
                return null;
            }
            case "onWebSocketText": {
                this.text((String)args[0]);
                return null;
            }
        }
        throw new AssertionError();
    }

    protected void opened() {
    }

    protected void closed(int statusCode, String reason) {
    }

    protected void error(Throwable cause) {
        LOGGER.log(Level.WARNING, "unhandled WebSocket service error", cause);
    }

    protected void binary(byte[] payload, int offset, int len) {
        LOGGER.warning("unexpected binary frame");
    }

    protected void text(String message) {
        LOGGER.warning("unexpected text frame");
    }

    protected final Future<Void> sendBinary(ByteBuffer data) {
        try {
            return (Future)this.remoteEndpoint.getClass().getMethod("sendBytesByFuture", ByteBuffer.class).invoke(this.remoteEndpoint, data);
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    protected final void sendBinary(ByteBuffer partialByte, boolean isLast) {
        try {
            this.remoteEndpoint.getClass().getMethod("sendPartialBytes", ByteBuffer.class, Boolean.TYPE).invoke(this.remoteEndpoint, partialByte, isLast);
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    protected final Future<Void> sendText(String text) {
        try {
            return (Future)this.remoteEndpoint.getClass().getMethod("sendStringByFuture", String.class).invoke(this.remoteEndpoint, text);
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    protected final void close() {
        try {
            this.session.getClass().getMethod("close", new Class[0]).invoke(this.session, new Object[0]);
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }
}

