/*
 * Decompiled with CFR 0.152.
 */
package hudson.slaves;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Slave;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;
import net.jcip.annotations.GuardedBy;

public class CloudRetentionStrategy
extends RetentionStrategy<AbstractCloudComputer> {
    private int idleMinutes;
    private static final Logger LOGGER = Logger.getLogger(CloudRetentionStrategy.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean disabled = SystemProperties.getBoolean(CloudRetentionStrategy.class.getName() + ".disabled");

    public CloudRetentionStrategy(int idleMinutes) {
        this.idleMinutes = idleMinutes;
    }

    @Override
    @GuardedBy(value="hudson.model.Queue.lock")
    public long check(AbstractCloudComputer c) {
        long idleMilliseconds;
        Slave computerNode = c.getNode();
        if (c.isIdle() && !disabled && computerNode != null && (idleMilliseconds = System.currentTimeMillis() - c.getIdleStartMilliseconds()) > TimeUnit.MINUTES.toMillis(this.idleMinutes)) {
            LOGGER.log(Level.INFO, "Disconnecting {0}", c.getName());
            try {
                ((AbstractCloudSlave)computerNode).terminate();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(Level.WARNING, "Failed to terminate " + c.getName(), e);
            }
        }
        return 1L;
    }

    @Override
    public void start(AbstractCloudComputer c) {
        c.connect(false);
    }
}

