/*
 * Decompiled with CFR 0.152.
 */
package jenkins.management;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ManagementLink;
import hudson.model.UpdateCenter;
import hudson.security.Permission;
import jenkins.management.Messages;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(ordinal=2.147483247E9)
@Symbol(value={"plugins"})
public class PluginsLink
extends ManagementLink {
    @Override
    public String getIconFileName() {
        return "plugin.svg";
    }

    @Override
    public String getDisplayName() {
        return Messages.PluginsLink_DisplayName();
    }

    @Override
    public String getDescription() {
        return Messages.PluginsLink_Description();
    }

    @Override
    public String getUrlName() {
        return "pluginManager";
    }

    @Override
    @NonNull
    public Permission getRequiredPermission() {
        return Jenkins.SYSTEM_READ;
    }

    @Override
    @NonNull
    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    @Restricted(value={NoExternalUse.class})
    public int getUpdateCount() {
        UpdateCenter updateCenter = Jenkins.get().getUpdateCenter();
        if (!updateCenter.isSiteDataReady()) {
            return 0;
        }
        return updateCenter.getUpdates().size();
    }
}

