/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.Messages;
import hudson.URLConnectionDecorator;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.util.FormValidation;
import hudson.util.Scrambler;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.security.stapler.StaplerAccessibleType;
import jenkins.util.JenkinsJVM;
import jenkins.util.SystemProperties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jenkinsci.Symbol;
import org.jvnet.robust_http_client.RetryableHttpStream;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

@StaplerAccessibleType
public final class ProxyConfiguration
extends AbstractDescribableImpl<ProxyConfiguration>
implements Saveable,
Serializable {
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = SystemProperties.getInteger("hudson.ProxyConfiguration.DEFAULT_CONNECT_TIMEOUT_MILLIS", (int)TimeUnit.SECONDS.toMillis(20L));
    public final String name;
    public final int port;
    private String userName;
    @Restricted(value={NoExternalUse.class})
    public String noProxyHost;
    @Deprecated
    private String password;
    private Secret secretPassword;
    private String testUrl;
    private transient Authenticator authenticator;
    private transient boolean authCacheSeeded;
    private static final XStream XSTREAM = new XStream2();
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public ProxyConfiguration(String name, int port) {
        this(name, port, null, null);
    }

    public ProxyConfiguration(String name, int port, String userName, String password) {
        this(name, port, userName, password, null);
    }

    public ProxyConfiguration(String name, int port, String userName, String password, String noProxyHost) {
        this(name, port, userName, password, noProxyHost, null);
    }

    public ProxyConfiguration(String name, int port, String userName, String password, String noProxyHost, String testUrl) {
        this.name = Util.fixEmptyAndTrim(name);
        this.port = port;
        this.userName = Util.fixEmptyAndTrim(userName);
        String tempPassword = Util.fixEmptyAndTrim(password);
        this.secretPassword = tempPassword != null ? Secret.fromString(tempPassword) : null;
        this.noProxyHost = Util.fixEmptyAndTrim(noProxyHost);
        this.testUrl = Util.fixEmptyAndTrim(testUrl);
        this.authenticator = this.newAuthenticator();
    }

    private Authenticator newAuthenticator() {
        return new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                String userName = ProxyConfiguration.this.getUserName();
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY && userName != null) {
                    return new PasswordAuthentication(userName, Secret.toString(ProxyConfiguration.this.secretPassword).toCharArray());
                }
                return null;
            }
        };
    }

    public String getUserName() {
        return this.userName;
    }

    public Secret getSecretPassword() {
        return this.secretPassword;
    }

    @Deprecated
    public String getPassword() {
        return Secret.toString(this.secretPassword);
    }

    @Deprecated
    public String getEncryptedPassword() {
        return this.secretPassword == null ? null : this.secretPassword.getEncryptedValue();
    }

    public String getTestUrl() {
        return this.testUrl;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public List<Pattern> getNoProxyHostPatterns() {
        return ProxyConfiguration.getNoProxyHostPatterns(this.noProxyHost);
    }

    public String getNoProxyHost() {
        return this.noProxyHost;
    }

    public static List<Pattern> getNoProxyHostPatterns(String noProxyHost) {
        if (noProxyHost == null) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> r = new ArrayList<Pattern>();
        for (String s : noProxyHost.split("[ \t\n,|]+")) {
            if (s.length() == 0) continue;
            r.add(Pattern.compile(s.replace(".", "\\.").replace("*", ".*")));
        }
        return r;
    }

    @DataBoundSetter
    public void setSecretPassword(Secret secretPassword) {
        this.secretPassword = secretPassword;
    }

    @DataBoundSetter
    public void setTestUrl(String testUrl) {
        this.testUrl = testUrl;
    }

    @DataBoundSetter
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @DataBoundSetter
    public void setNoProxyHost(String noProxyHost) {
        this.noProxyHost = noProxyHost;
    }

    @Deprecated
    public Proxy createProxy() {
        return this.createProxy(null);
    }

    public Proxy createProxy(String host) {
        return ProxyConfiguration.createProxy(host, this.name, this.port, this.noProxyHost);
    }

    public static Proxy createProxy(String host, String name, int port, String noProxyHost) {
        if (host != null && noProxyHost != null) {
            for (Pattern p : ProxyConfiguration.getNoProxyHostPatterns(noProxyHost)) {
                if (!p.matcher(host).matches()) continue;
                return Proxy.NO_PROXY;
            }
        }
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(name, port));
    }

    @Override
    public void save() throws IOException {
        if (BulkChange.contains(this)) {
            return;
        }
        XmlFile config = ProxyConfiguration.getXmlFile();
        config.write(this);
        SaveableListener.fireOnChange(this, config);
    }

    private Object readResolve() {
        if (this.secretPassword == null) {
            this.secretPassword = Secret.fromString(Scrambler.descramble(this.password));
        }
        this.password = null;
        this.authenticator = this.newAuthenticator();
        return this;
    }

    public static XmlFile getXmlFile() {
        return new XmlFile(XSTREAM, new File(Jenkins.get().getRootDir(), "proxy.xml"));
    }

    public static ProxyConfiguration load() throws IOException {
        XmlFile f = ProxyConfiguration.getXmlFile();
        if (f.exists()) {
            return (ProxyConfiguration)f.read();
        }
        return null;
    }

    public static URLConnection open(URL url) throws IOException {
        URLConnection con;
        ProxyConfiguration p = ProxyConfiguration.get();
        if (p == null) {
            con = url.openConnection();
        } else {
            Proxy proxy = p.createProxy(url.getHost());
            con = url.openConnection(proxy);
            if (p.getUserName() != null) {
                Authenticator.setDefault(p.authenticator);
                p.jenkins48775workaround(proxy, url);
            }
        }
        if (DEFAULT_CONNECT_TIMEOUT_MILLIS > 0) {
            con.setConnectTimeout(DEFAULT_CONNECT_TIMEOUT_MILLIS);
        }
        if (JenkinsJVM.isJenkinsJVM()) {
            ProxyConfiguration.decorate(con);
        }
        return con;
    }

    public static InputStream getInputStream(URL url) throws IOException {
        ProxyConfiguration p = ProxyConfiguration.get();
        if (p == null) {
            return new RetryableHttpStream(url);
        }
        Proxy proxy = p.createProxy(url.getHost());
        RetryableHttpStream is = new RetryableHttpStream(url, proxy);
        if (p.getUserName() != null) {
            Authenticator.setDefault(p.authenticator);
            p.jenkins48775workaround(proxy, url);
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jenkins48775workaround(Proxy proxy, URL url) {
        if ("https".equals(url.getProtocol()) && !this.authCacheSeeded && proxy != Proxy.NO_PROXY) {
            HttpURLConnection preAuth = null;
            try {
                preAuth = (HttpURLConnection)new URL("http", url.getHost(), -1, "/").openConnection(proxy);
                preAuth.setRequestMethod("HEAD");
                preAuth.connect();
            }
            catch (IOException iOException) {
            }
            finally {
                if (preAuth != null) {
                    preAuth.disconnect();
                }
            }
            this.authCacheSeeded = true;
        } else if ("https".equals(url.getProtocol())) {
            this.authCacheSeeded = this.authCacheSeeded || proxy != Proxy.NO_PROXY;
        }
    }

    @CheckForNull
    private static ProxyConfiguration get() {
        if (JenkinsJVM.isJenkinsJVM()) {
            return ProxyConfiguration._get();
        }
        return null;
    }

    @CheckForNull
    private static ProxyConfiguration _get() {
        JenkinsJVM.checkJenkinsJVM();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        return jenkins == null ? null : jenkins.proxy;
    }

    private static void decorate(URLConnection con) throws IOException {
        for (URLConnectionDecorator d : URLConnectionDecorator.all()) {
            d.decorate(con);
        }
    }

    static {
        XSTREAM.alias("proxy", ProxyConfiguration.class);
    }

    @Extension
    @Symbol(value={"proxy"})
    public static class DescriptorImpl
    extends Descriptor<ProxyConfiguration> {
        @Override
        @NonNull
        public String getDisplayName() {
            return "Proxy Configuration";
        }

        public FormValidation doCheckPort(@QueryParameter String value) {
            int port;
            if ((value = Util.fixEmptyAndTrim(value)) == null) {
                return FormValidation.ok();
            }
            try {
                port = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error(Messages.PluginManager_PortNotANumber());
            }
            if (port < 0 || port > 65535) {
                return FormValidation.error(Messages.PluginManager_PortNotInRange(0, 65535));
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doValidateProxy(@QueryParameter(value="testUrl") String testUrl, @QueryParameter(value="name") String name, @QueryParameter(value="port") int port, @QueryParameter(value="userName") String userName, @QueryParameter(value="secretPassword") Secret password, @QueryParameter(value="noProxyHost") String noProxyHost) {
            String host;
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            if (Util.fixEmptyAndTrim(testUrl) == null) {
                return FormValidation.error(Messages.ProxyConfiguration_TestUrlRequired());
            }
            try {
                URL url = new URL(testUrl);
                host = url.getHost();
            }
            catch (MalformedURLException e) {
                return FormValidation.error(Messages.ProxyConfiguration_MalformedTestUrl(testUrl));
            }
            GetMethod method = null;
            try {
                int code;
                method = new GetMethod(testUrl);
                method.getParams().setParameter("http.socket.timeout", (Object)(DEFAULT_CONNECT_TIMEOUT_MILLIS > 0 ? DEFAULT_CONNECT_TIMEOUT_MILLIS : (int)TimeUnit.SECONDS.toMillis(30L)));
                HttpClient client = new HttpClient();
                if (Util.fixEmptyAndTrim(name) != null && !this.isNoProxyHost(host, noProxyHost)) {
                    client.getHostConfiguration().setProxy(name, port);
                    Credentials credentials = this.createCredentials(userName, password != null ? password.getPlainText() : null);
                    AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1);
                    client.getState().setProxyCredentials(scope, credentials);
                }
                if ((code = client.executeMethod((HttpMethod)method)) != 200) {
                    FormValidation formValidation = FormValidation.error(Messages.ProxyConfiguration_FailedToConnect(testUrl, code));
                    return formValidation;
                }
            }
            catch (IOException e) {
                FormValidation formValidation = FormValidation.error(e, Messages.ProxyConfiguration_FailedToConnectViaProxy(testUrl));
                return formValidation;
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
            return FormValidation.ok(Messages.ProxyConfiguration_Success());
        }

        private boolean isNoProxyHost(String host, String noProxyHost) {
            if (host != null && noProxyHost != null) {
                for (Pattern p : ProxyConfiguration.getNoProxyHostPatterns(noProxyHost)) {
                    if (!p.matcher(host).matches()) continue;
                    return true;
                }
            }
            return false;
        }

        private Credentials createCredentials(String userName, String password) {
            if (userName.indexOf(92) >= 0) {
                String domain = userName.substring(0, userName.indexOf(92));
                String user = userName.substring(userName.indexOf(92) + 1);
                return new NTCredentials(user, Secret.fromString(password).getPlainText(), "", domain);
            }
            return new UsernamePasswordCredentials(userName, Secret.fromString(password).getPlainText());
        }
    }
}

