/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.PluginWrapper;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.lifecycle.RestartNotSupportedException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@Extension
public class DisablePluginCommand
extends CLICommand {
    @Argument(metaVar="plugin1 plugin2 plugin3", required=true, usage="Plugins to be disabled.")
    private List<String> pluginNames;
    @Option(name="-restart", aliases={"-r"}, usage="Restart Jenkins after disabling plugins.")
    private boolean restart;
    @Option(name="-strategy", aliases={"-s"}, metaVar="strategy", usage="How to process the dependent plugins. \n- none: if a mandatory dependent plugin exists and it is enabled, the plugin cannot be disabled (default value).\n- mandatory: all mandatory dependent plugins are also disabled, optional dependent plugins remain enabled.\n- all: all dependent plugins are also disabled, no matter if its dependency is optional or mandatory.")
    private String strategy = PluginWrapper.PluginDisableStrategy.NONE.toString();
    @Option(name="-quiet", aliases={"-q"}, usage="Be quiet, print only the error messages")
    private boolean quiet;
    private static final int INDENT_SPACE = 3;
    static final int RETURN_CODE_NOT_DISABLED_DEPENDANTS = 16;
    static final int RETURN_CODE_NO_SUCH_PLUGIN = 17;

    @Override
    public String getShortDescription() {
        return Messages.DisablePluginCommand_ShortDescription();
    }

    @Override
    protected void printUsageSummary(PrintStream stderr) {
        super.printUsageSummary(stderr);
        stderr.println(Messages.DisablePluginCommand_PrintUsageSummary());
    }

    @Override
    protected int run() throws Exception {
        PluginWrapper.PluginDisableStrategy strategyToUse;
        Jenkins jenkins = Jenkins.get();
        jenkins.checkPermission(Jenkins.ADMINISTER);
        try {
            strategyToUse = PluginWrapper.PluginDisableStrategy.valueOf(this.strategy.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(Messages.DisablePluginCommand_NoSuchStrategy(this.strategy, String.format("%s, %s, %s", new Object[]{PluginWrapper.PluginDisableStrategy.NONE, PluginWrapper.PluginDisableStrategy.MANDATORY, PluginWrapper.PluginDisableStrategy.ALL})), iae);
        }
        List<PluginWrapper.PluginDisableResult> results = jenkins.pluginManager.disablePlugins(strategyToUse, this.pluginNames);
        this.printResults(results);
        this.restartIfNecessary(results);
        return this.getResultCode(results);
    }

    private void printResults(List<PluginWrapper.PluginDisableResult> results) {
        for (PluginWrapper.PluginDisableResult oneResult : results) {
            this.printResult(oneResult, 0);
        }
    }

    private void printIndented(int indent, String format, String ... arguments) {
        if (indent == 0) {
            this.stdout.format(format + "%n", arguments);
        } else {
            Object[] newArgs = new String[arguments.length + 1];
            newArgs[0] = " ";
            System.arraycopy(arguments, 0, newArgs, 1, arguments.length);
            String f = "%" + indent + "s" + format + "%n";
            this.stdout.format(f, newArgs);
        }
    }

    private void printResult(PluginWrapper.PluginDisableResult oneResult, int indent) {
        PluginWrapper.PluginDisableStatus status = oneResult.getStatus();
        if (this.quiet && (PluginWrapper.PluginDisableStatus.DISABLED.equals((Object)status) || PluginWrapper.PluginDisableStatus.ALREADY_DISABLED.equals((Object)status))) {
            return;
        }
        this.printIndented(indent, Messages.DisablePluginCommand_StatusMessage(oneResult.getPlugin(), (Object)oneResult.getStatus(), oneResult.getMessage()), new String[0]);
        if (oneResult.getDependentsDisableStatus().size() > 0) {
            indent += 3;
            for (PluginWrapper.PluginDisableResult oneDependentResult : oneResult.getDependentsDisableStatus()) {
                this.printResult(oneDependentResult, indent);
            }
        }
    }

    private void restartIfNecessary(List<PluginWrapper.PluginDisableResult> results) throws RestartNotSupportedException {
        block1: {
            if (!this.restart) break block1;
            for (PluginWrapper.PluginDisableResult oneResult : results) {
                if (this.restartIfNecessary(oneResult)) break;
            }
        }
    }

    private boolean restartIfNecessary(PluginWrapper.PluginDisableResult oneResult) throws RestartNotSupportedException {
        PluginWrapper.PluginDisableStatus status = oneResult.getStatus();
        if (PluginWrapper.PluginDisableStatus.DISABLED.equals((Object)status)) {
            Jenkins.get().safeRestart();
            return true;
        }
        if (oneResult.getDependentsDisableStatus().size() > 0) {
            for (PluginWrapper.PluginDisableResult oneDependentResult : oneResult.getDependentsDisableStatus()) {
                if (!this.restartIfNecessary(oneDependentResult)) continue;
                return true;
            }
        }
        return false;
    }

    private int getResultCode(List<PluginWrapper.PluginDisableResult> results) {
        PluginWrapper.PluginDisableResult oneResult;
        int result = 0;
        Iterator<PluginWrapper.PluginDisableResult> iterator = results.iterator();
        while (iterator.hasNext() && (result = this.getResultCode(oneResult = iterator.next())) == 0) {
        }
        return result;
    }

    private int getResultCode(PluginWrapper.PluginDisableResult result) {
        int returnCode = 0;
        switch (result.getStatus()) {
            case NOT_DISABLED_DEPENDANTS: {
                returnCode = 16;
                break;
            }
            case NO_SUCH_PLUGIN: {
                returnCode = 17;
                break;
            }
            default: {
                PluginWrapper.PluginDisableResult oneDependentResult;
                Iterator<PluginWrapper.PluginDisableResult> iterator = result.getDependentsDisableStatus().iterator();
                while (iterator.hasNext() && (returnCode = this.getResultCode(oneDependentResult = iterator.next())) == 0) {
                }
                break;
            }
        }
        return returnCode;
    }
}

